/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class Util {
    private static final Logger LOG = Logger.getLogger(Util.class);
    public static final Class<?> ByteArrayClass = new byte[0].getClass();
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static List<String> readLinesFromFile(String resourceName) {
        InputStream stream = Util.getResourceAsStream(resourceName);
        if (stream != null) {
            return Util.readLinesFromStream(stream);
        }
        LOG.warn((Object)(resourceName + " not found"));
        return new ArrayList<String>();
    }

    public static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (url == null) {
            url = Util.getResourceFromClassloader(resource, stripped, classLoader);
        }
        if (url == null) {
            url = Util.getResourceFromClassloader(resource, stripped, Util.class.getClassLoader());
        }
        if (url == null) {
            LOG.debug((Object)"Trying getResource");
            url = Util.class.getResource(resource);
            if (url == null) {
                url = Util.class.getResource(stripped);
            }
        }
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't open stream on " + url));
            }
        }
        return null;
    }

    private static URL getResourceFromClassloader(String resource, String stripped, ClassLoader classLoader) {
        LOG.debug((Object)("Trying class loader " + classLoader));
        URL url = null;
        if (classLoader instanceof URLClassLoader) {
            LOG.debug((Object)"Trying as UCL class loader");
            URLClassLoader ucl = (URLClassLoader)classLoader;
            url = ucl.findResource(resource);
            if (url == null) {
                url = ucl.findResource(stripped);
            }
        }
        if (url == null) {
            url = classLoader.getResource(resource);
        }
        if (url == null) {
            url = classLoader.getResource(stripped);
        }
        return url;
    }

    public static List<String> readLinesFromStream(InputStream inputStream) {
        assert (inputStream != null) : "inputStream != null";
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ("".equals(line = Util.trim(line))) continue;
                result.add(line);
            }
            inputStream.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Reading from inputstream", (Throwable)e);
        }
        return result;
    }

    public static String trim(String src) {
        return src == null ? "" : src.trim();
    }

    public static <T> T copyObject(Class<T> clazz, T sourceObject) {
        try {
            byte[] byteArray = Util.toByteArray(sourceObject);
            return Util.fromByteArray(clazz, byteArray);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not copy ", e);
        }
    }

    public static byte[] toByteArray(Object sourceObject) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        out.writeObject(sourceObject);
        out.flush();
        out.close();
        return outStream.toByteArray();
    }

    public static <T> T fromByteArray(Class<T> clazz, byte[] byteArray) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(bis);
        T result = clazz.cast(objectInputStream.readObject());
        objectInputStream.close();
        return result;
    }

    public static <T> T fromInputStream(Class<T> clazz, InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return clazz.cast(objectInputStream.readObject());
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
    }

    public static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return Util.fillup(hours) + ":" + Util.fillup(minutes %= 60L) + ":" + Util.fillup(seconds %= 60L);
    }

    public static void deleteDirectory(File directory) {
        assert (directory != null) : "directory != null";
        if (directory.exists() && directory.isDirectory()) {
            String[] files;
            for (String fileName : files = directory.list()) {
                File file = new File(directory, fileName);
                Util.deleteDirectory(file);
            }
        }
        directory.delete();
    }

    private static String fillup(long time) {
        return time > 9L ? String.valueOf(time) : "0" + time;
    }

    public static String getStringFromStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Util.copy(inputStream, outputStream);
        String result = outputStream.toString();
        inputStream.close();
        outputStream.close();
        return result;
    }
}

