package address.book.service.mapper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import hbm.service.mapper.AbstractBusinessMapperService;
import address.book.daos.AddressesDao;
import address.book.domain.Address;
import address.book.mapper.AddressesMapper;
import address.book.model.Addresses;

@Transactional
@Service("addressService")
public class AddressesBusinessMapperService extends
		AbstractBusinessMapperService<Integer, Address, Addresses, AddressesDao, AddressesMapper> implements AddressService {
	
	@Autowired
	public void setAddressesDao(AddressesDao addressesDao) {
		setDao(addressesDao);
	}
	
	@Autowired
	public void setAddressesMapper(AddressesMapper addressesMapper) {
		setMapper(addressesMapper);
	}
}
