/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.entitymapper;

import de.alpharogroup.db.domain.BusinessObject;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityBOMapper;
import de.alpharogroup.lang.TypeArgumentsUtils;
import java.util.Collections;
import java.util.List;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;

public abstract class AbstractEntityBOMapper<E extends BaseEntity<?>, BO extends BusinessObject<?>>
implements EntityBOMapper<E, BO> {
    private final Class<E> entityClass = TypeArgumentsUtils.getTypeArgument(AbstractEntityBOMapper.class, this.getClass(), (int)0);
    private final Class<BO> businessObjectClass = TypeArgumentsUtils.getTypeArgument(AbstractEntityBOMapper.class, this.getClass(), (int)1);

    @Override
    public E toEntity(BO businessObject) {
        return this.toEntity(businessObject, Collections.emptyList());
    }

    @Override
    public E toEntity(BO businessObject, List<String> mappingFiles) {
        return (E)((BaseEntity)this.newMapper(mappingFiles).map(businessObject, this.getEntityClass()));
    }

    @Override
    public BO toBusinessObject(E entity) {
        return this.toBusinessObject(entity, Collections.emptyList());
    }

    @Override
    public BO toBusinessObject(E entity, List<String> mappingFiles) {
        return (BO)((BusinessObject)this.newMapper(mappingFiles).map(entity, this.getBusinessObjectClass()));
    }

    public Mapper newMapper() {
        return this.newMapper(Collections.emptyList());
    }

    public Mapper newMapper(List<String> mappingFiles) {
        return new DozerBeanMapper(mappingFiles);
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<BO> getBusinessObjectClass() {
        return this.businessObjectClass;
    }
}

