/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.service.sessionfactory;

import de.alpharogroup.db.dao.sessionfactory.SessionFactoryDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.sessionfactory.api.SessionFactoryBusinessService;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.type.Type;

public abstract class AbstractBusinessService<T extends BaseEntity<PK>, PK extends Serializable, DAO extends SessionFactoryDao<T, PK>>
implements SessionFactoryBusinessService<T, PK> {
    private static final long serialVersionUID = 1L;
    private DAO dao;

    @Override
    public void delete(List<T> objects) {
        for (BaseEntity t : objects) {
            this.delete((T)t);
        }
    }

    @Override
    public void delete(PK id) {
        this.getDao().delete(id);
    }

    @Override
    public void delete(T id) {
        this.getDao().delete(id);
    }

    @Override
    public void deleteAndFlush(List<T> objects) {
        this.delete((T)objects);
        this.flush();
    }

    @Override
    public void deleteAndFlush(PK id) {
        this.delete((T)id);
        this.flush();
    }

    @Override
    public void deleteAndFlush(T t) {
        this.delete(t);
        this.flush();
    }

    @Override
    public void evict(T object) {
        this.getDao().evict(object);
    }

    @Override
    public boolean exists(PK id) {
        return this.getDao().exists(id);
    }

    @Override
    public List<T> find(String hqlQuery, String[] params, Object[] paramValues, Type[] paramTypes, Integer start, Integer count) {
        return this.getDao().find(hqlQuery, params, paramValues, paramTypes, start, count);
    }

    @Override
    public List<T> findAll() {
        return this.getDao().findAll();
    }

    @Override
    public List<T> findByCriteria(Criterion ... criterion) {
        return this.getDao().findByCriteria(criterion);
    }

    @Override
    public List<T> findByExample(T exampleInstance, String ... excludeProperty) {
        return this.getDao().findByExample(exampleInstance, excludeProperty);
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public T get(PK id) {
        return (T)this.getDao().get(id);
    }

    public Query getQuery(String s) {
        return this.getDao().getQuery(s);
    }

    @Override
    public Session getSession() {
        return this.getDao().getSession();
    }

    @Override
    public T load(PK id) {
        return (T)this.getDao().load(id);
    }

    @Override
    public List<T> merge(List<T> objects) {
        return this.getDao().merge(objects);
    }

    @Override
    public T merge(T object) {
        return (T)this.getDao().merge(object);
    }

    @Override
    public T mergeAndFlush(T object) {
        try {
            T t = this.merge(object);
            return t;
        }
        finally {
            this.flush();
        }
    }

    @Override
    public void refresh(T object) {
        this.getDao().refresh(object);
    }

    @Override
    public List<PK> save(List<T> objects) {
        return this.getDao().save(objects);
    }

    @Override
    public PK save(T newInstance) {
        return (PK)this.getDao().save(newInstance);
    }

    @Override
    public List<PK> saveAndFlush(List<T> objects) {
        try {
            PK PK = this.save((T)objects);
            return PK;
        }
        finally {
            this.flush();
        }
    }

    @Override
    public PK saveAndFlush(T object) {
        try {
            PK PK = this.save(object);
            return PK;
        }
        finally {
            this.flush();
        }
    }

    @Override
    public void saveOrUpdate(List<T> objects) {
        this.getDao().saveOrUpdate(objects);
    }

    @Override
    public void saveOrUpdate(T object) {
        this.getDao().saveOrUpdate(object);
    }

    @Override
    public void saveOrUpdateAndFlush(List<T> objects) {
        this.getDao().saveOrUpdate(objects);
        this.flush();
    }

    @Override
    public void saveOrUpdateAndFlush(T object) {
        this.getDao().saveOrUpdate(object);
        this.flush();
    }

    @Override
    public void setSession(Session session) {
        this.getDao().setSession(session);
    }

    public DAO getDao() {
        return this.dao;
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }
}

