/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.db.service.entitymapper;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.domain.BusinessObject;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityBOMapper;
import de.alpharogroup.db.service.entitymapper.BusinessMapperService;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.lang.TypeArgumentsUtils;
import java.io.Serializable;

public abstract class AbstractBusinessMapperService<PK extends Serializable, BO extends BusinessObject<PK>, E extends BaseEntity<PK>, DAO extends EntityManagerDao<E, PK>, M extends EntityBOMapper<E, BO>>
implements BusinessMapperService<PK, BO> {
    private DAO dao;
    private M mapper;
    private final Class<E> entityClass = TypeArgumentsUtils.getTypeArgument(AbstractBusinessMapperService.class, this.getClass(), (int)2);
    private final Class<BO> businessObjectClass = TypeArgumentsUtils.getTypeArgument(AbstractBusinessMapperService.class, this.getClass(), (int)1);

    @Override
    public BO read(PK id) {
        BaseEntity entity = this.dao.get(id);
        return this.getMapper().toBusinessObject((BaseEntity)entity);
    }

    @Override
    public BO create(BO businessObject) {
        Object entity = this.getMapper().toEntity(businessObject);
        businessObject.setId((Serializable)this.dao.save(entity));
        return businessObject;
    }

    @Override
    public void update(BO businessObject) {
        BaseEntity entity = this.dao.get((Serializable)businessObject.getId());
        ObjectExtensions.copyQuietly((Object)entity, businessObject);
        this.dao.merge(entity);
    }

    @Override
    public void delete(PK id) {
        this.dao.delete(id);
    }

    public void setDao(DAO dao) {
        this.dao = dao;
    }

    public DAO getDao() {
        return this.dao;
    }

    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    public M getMapper() {
        return this.mapper;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public Class<BO> getBusinessObjectClass() {
        return this.businessObjectClass;
    }
}

