/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dating.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.dating.system.daos.FriendshipRequestsDao;
import de.alpharogroup.dating.system.entities.FriendshipRequests;
import de.alpharogroup.dating.system.enums.FriendshipRequestsState;
import de.alpharogroup.dating.system.service.api.FriendshipRequestsService;
import de.alpharogroup.dating.system.service.utils.HqlStringCreator;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="friendshipRequestsService")
public class FriendshipRequestsBusinessService
extends AbstractBusinessService<FriendshipRequests, Integer, FriendshipRequestsDao>
implements FriendshipRequestsService {
    private static final long serialVersionUID = 1L;

    @Override
    public FriendshipRequests find(Users requestor, Users requestedUser) {
        return this.find(requestor, requestedUser, null);
    }

    @Override
    public FriendshipRequests find(Users requestor, Users requestedUser, FriendshipRequestsState state) {
        List<FriendshipRequests> friendshipRequests = this.findAll(requestor, requestedUser, state);
        return (FriendshipRequests)ListExtensions.getFirst(friendshipRequests);
    }

    @Override
    public List<FriendshipRequests> findAll(Users requestor, Users requestedUser, FriendshipRequestsState state) {
        String hqlString = HqlStringCreator.forFriendshipRequests(requestor, requestedUser, state);
        Query query = this.getQuery(hqlString);
        if (requestor != null) {
            query.setParameter("requestor", (Object)requestor);
        }
        if (requestedUser != null) {
            query.setParameter("requestedUser", (Object)requestedUser);
        }
        if (state != null) {
            query.setParameter("state", (Object)state);
        }
        List friendshipRequests = query.getResultList();
        return friendshipRequests;
    }

    @Autowired
    public void setFriendshipRequestsDao(FriendshipRequestsDao friendshipRequestsDao) {
        this.setDao((EntityManagerDao)friendshipRequestsDao);
    }
}

