/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dating.system.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.dating.system.daos.ProfileNoticesDao;
import de.alpharogroup.dating.system.entities.ProfileNotices;
import de.alpharogroup.dating.system.entities.UserProfiles;
import de.alpharogroup.dating.system.service.api.ProfileNoticesService;
import de.alpharogroup.dating.system.service.utils.HqlStringCreator;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="profileNoticesService")
public class ProfileNoticesBusinessService
extends AbstractBusinessService<ProfileNotices, Integer, ProfileNoticesDao>
implements ProfileNoticesService {
    private static final long serialVersionUID = 1L;

    @Override
    public List<ProfileNotices> find(Users user) {
        List<ProfileNotices> profileNotices = this.findAll(user, null);
        return profileNotices;
    }

    @Override
    public List<ProfileNotices> findAll(Users user, UserProfiles userProfile) {
        String hqlString = HqlStringCreator.forProfileNotice(user, userProfile);
        Query query = this.getQuery(hqlString);
        if (user != null) {
            query.setParameter("user", (Object)user);
        }
        if (userProfile != null) {
            query.setParameter("userProfile", (Object)userProfile);
        }
        List profileNotices = query.getResultList();
        return profileNotices;
    }

    @Override
    public ProfileNotices findProfileNotice(Users user, UserProfiles userProfile) {
        List<ProfileNotices> profileNotices = this.findAll(user, userProfile);
        return (ProfileNotices)ListExtensions.getFirst(profileNotices);
    }

    @Autowired
    public void setProfileNoticesDao(ProfileNoticesDao profileNoticeDao) {
        this.setDao((EntityManagerDao)profileNoticeDao);
    }
}

