/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dating.system.service;

import de.alpharogroup.dating.system.daos.FavoriteMembersDao;
import de.alpharogroup.dating.system.entities.FavoriteMembers;
import de.alpharogroup.dating.system.entities.UserProfiles;
import de.alpharogroup.dating.system.service.api.FavoriteMembersService;
import de.alpharogroup.dating.system.service.utils.HqlStringCreator;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="favoriteMembersService")
public class FavoriteMembersBusinessService
extends AbstractBusinessService<FavoriteMembers, Integer, FavoriteMembersDao>
implements FavoriteMembersService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setFavoriteMembersDao(FavoriteMembersDao favoriteMembersDao) {
        this.setDao((EntityManagerDao)favoriteMembersDao);
    }

    @Override
    @Transactional
    public FavoriteMembers find(Users owner, UserProfiles favorite) {
        List<FavoriteMembers> favoriteMembers = this.findAll(owner, favorite);
        if (favoriteMembers != null && !favoriteMembers.isEmpty()) {
            return favoriteMembers.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public List<FavoriteMembers> findAll(Users owner, UserProfiles favorite) {
        String hqlString = HqlStringCreator.forFavoriteMembers(owner, favorite);
        Query query = this.getQuery(hqlString);
        if (owner != null) {
            query.setParameter("owner", (Object)owner);
        }
        if (favorite != null) {
            query.setParameter("favorite", (Object)favorite);
        }
        List favoriteMembers = query.getResultList();
        return favoriteMembers;
    }

    @Override
    public List<FavoriteMembers> find(Users owner) {
        String hqlString = HqlStringCreator.forFavoriteMembers(owner, null);
        Query query = this.getQuery(hqlString);
        query.setParameter("owner", (Object)owner);
        List favoriteMembers = query.getResultList();
        return favoriteMembers;
    }
}

