/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dating.system.service;

import de.alpharogroup.dating.system.daos.ProfileVisitorsDao;
import de.alpharogroup.dating.system.entities.ProfileVisitors;
import de.alpharogroup.dating.system.entities.UserProfiles;
import de.alpharogroup.dating.system.service.api.ProfileVisitorsService;
import de.alpharogroup.dating.system.service.utils.HqlStringCreator;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.entities.Users;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="profileVisitorsService")
public class ProfileVisitorsBusinessService
extends AbstractBusinessService<ProfileVisitors, Integer, ProfileVisitorsDao>
implements ProfileVisitorsService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setProfileVisitorsDao(ProfileVisitorsDao profileVisitorsDao) {
        this.setDao((EntityManagerDao)profileVisitorsDao);
    }

    @Override
    public ProfileVisitors find(Users visitor, UserProfiles visitedProfile) {
        List<ProfileVisitors> profileVisitors = this.findAll(visitor, visitedProfile);
        if (profileVisitors != null && !profileVisitors.isEmpty()) {
            return profileVisitors.get(0);
        }
        return null;
    }

    @Override
    public List<ProfileVisitors> findAll(Users visitor, UserProfiles visitedProfile) {
        String hqlString = HqlStringCreator.forProfileVisitors(visitor, visitedProfile);
        Query query = this.getQuery(hqlString);
        if (visitor != null) {
            query.setParameter("visitor", (Object)visitor);
        }
        if (visitedProfile != null) {
            query.setParameter("visitedProfile", (Object)visitedProfile);
        }
        List profileVisitors = query.getResultList();
        return profileVisitors;
    }

    @Override
    public List<ProfileVisitors> findProfileVisitors(UserProfiles visitedProfile) {
        List<ProfileVisitors> profileVisitors = this.findAll(null, visitedProfile);
        return profileVisitors;
    }
}

