/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.dating.system.service;

import de.alpharogroup.dating.system.daos.UserProfilesDao;
import de.alpharogroup.dating.system.entities.UserProfiles;
import de.alpharogroup.dating.system.service.api.UserProfilesService;
import de.alpharogroup.dating.system.service.utils.HqlStringCreator;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.resource.system.application.model.ModelSynchronizer;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.resource.system.service.api.ResourcesService;
import de.alpharogroup.user.management.entities.Users;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="userProfilesService")
public class UserProfilesBusinessService
extends AbstractBusinessService<UserProfiles, Integer, UserProfilesDao>
implements UserProfilesService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ResourcesService resourcesService;

    @Autowired
    public void setUserProfilesDao(UserProfilesDao userProfileDao) {
        this.setDao((EntityManagerDao)userProfileDao);
    }

    @Override
    public List<UserProfiles> findUserProfiles(Users user) {
        return this.find(user);
    }

    public List<UserProfiles> find(Users user) {
        if (user != null) {
            String hqlString = HqlStringCreator.forUserProfile(user);
            Query query = this.getQuery(hqlString);
            query.setParameter("user", (Object)user);
            List userProfiles = query.getResultList();
            return userProfiles;
        }
        return null;
    }

    @Override
    public UserProfiles findUserProfile(Users user) {
        List<UserProfiles> userProfiles = this.findUserProfiles(user);
        if (userProfiles != null && !userProfiles.isEmpty()) {
            return userProfiles.get(0);
        }
        return null;
    }

    @Override
    public Resources findProfileImage(Users user) {
        UserProfiles profile = this.findUserProfile(user);
        if (profile != null) {
            return profile.getUserImage();
        }
        return null;
    }

    @Override
    public Resources persistProfileImage(ResourcesModel resourceModel, Users user) {
        Resources image = ModelSynchronizer.convert((ResourcesModel)resourceModel);
        UserProfiles profile = this.findUserProfile(user);
        if (profile.getUserImage() != null) {
            Integer imgId = (Integer)profile.getUserImage().getId();
            profile.setUserImage(null);
            profile = (UserProfiles)this.merge((BaseEntity)profile);
            if (3 < imgId) {
                this.resourcesService.delete((Serializable)imgId);
            }
        }
        image = (Resources)this.resourcesService.merge((BaseEntity)image);
        profile.setUserImage(image);
        this.merge((BaseEntity)profile);
        return image;
    }

    @Override
    public UserProfiles persistDefaultProfileImage(Users user) {
        Resources defaultImage = this.resourcesService.getDefaultPlaceholder();
        return this.persistDefaultProfileImage(user, defaultImage);
    }

    @Override
    public UserProfiles persistDefaultProfileImage(Users user, Resources defaultImage) {
        Integer imgId;
        UserProfiles profile = this.findUserProfile(user);
        if (profile != null && profile.getUserImage() != null && 3 < (imgId = (Integer)profile.getUserImage().getId())) {
            return profile;
        }
        if (defaultImage != null && profile != null) {
            profile.setUserImage(defaultImage);
            profile = (UserProfiles)this.merge((BaseEntity)profile);
        }
        return profile;
    }
}

