/*
 * Decompiled with CFR 0.152.
 */
package db.resource.bundles.service;

import db.resource.bundles.daos.ResourcebundlesDao;
import db.resource.bundles.factories.ResourceBundlesDomainObjectFactory;
import db.resource.bundles.model.Resourcebundles;
import db.resource.bundles.service.api.ResourcebundlesService;
import db.resource.bundles.service.util.HqlStringCreator;
import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Query;
import net.sourceforge.jaulp.collections.ListUtils;
import net.sourceforge.jaulp.locale.LocaleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="resourcebundlesService")
public class ResourcebundlesBusinessService
extends AbstractBusinessService<Resourcebundles, Integer, ResourcebundlesDao>
implements ResourcebundlesService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setResourcebundlesDao(ResourcebundlesDao resourcebundlesDao) {
        this.setDao((EntityManagerDao)resourcebundlesDao);
    }

    @Override
    public List<Resourcebundles> findResourceBundles(String baseName, Locale locale) {
        return this.find(baseName, LocaleUtils.getLocaleFilenameSuffix((Locale)locale), null, null);
    }

    @Override
    public List<Resourcebundles> findResourceBundles(String baseName, Locale locale, String key) {
        return this.find(baseName, LocaleUtils.getLocaleFilenameSuffix((Locale)locale), key, null);
    }

    @Override
    public Resourcebundles getKey(String baseName, Locale locale, String key) {
        return (Resourcebundles)ListUtils.getFirst(this.findResourceBundles(baseName, locale, key));
    }

    @Override
    public void updateProperties(Properties properties, String baseName, Locale locale) {
        if (baseName == null || baseName.isEmpty()) {
            throw new IllegalArgumentException("Parameter baseName should not be null or empty.");
        }
        String localeName = LocaleUtils.getLocaleFilenameSuffix((Locale)locale);
        for (Map.Entry<Object, Object> element : properties.entrySet()) {
            String key = element.getKey().toString().trim();
            String value = element.getValue().toString().trim();
            Resourcebundles resourcebundle = this.getKey(baseName, locale, key);
            if (resourcebundle != null) {
                resourcebundle.setValue(value);
            } else {
                resourcebundle = ResourceBundlesDomainObjectFactory.getInstance().newResourcebundles(baseName, localeName, key, value);
            }
            this.merge(resourcebundle);
        }
    }

    @Override
    public List<Resourcebundles> find(String baseName, String locale, String key, String value) {
        String hqlString = HqlStringCreator.forResourcebundles(baseName, locale, key, value);
        Query query = this.getQuery(hqlString);
        if (baseName != null && !baseName.isEmpty()) {
            query.setParameter("baseName", (Object)baseName);
        }
        if (locale != null && !locale.isEmpty()) {
            query.setParameter("locale", (Object)locale);
        }
        if (key != null && !key.isEmpty()) {
            query.setParameter("key", (Object)key);
        }
        if (value != null && !value.isEmpty()) {
            query.setParameter("value", (Object)value);
        }
        List resourcebundles = query.getResultList();
        return resourcebundles;
    }
}

