/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.service.domain;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.db.repository.api.GenericRepository;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.lang.TypeArgumentsExtensions;
import de.alpharogroup.merge.object.MergeObjectExtensions;
import de.alpharogroup.service.domain.DomainService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractDomainService<PK extends Serializable, DO extends DomainObject<PK>, E extends BaseEntity<PK>, REPOSITORY extends GenericRepository<E, PK>, M extends EntityDOMapper<E, DO>>
implements DomainService<PK, DO> {
    private final Class<DO> domainObjectClass = TypeArgumentsExtensions.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)1);
    private final Class<E> entityClass = TypeArgumentsExtensions.getTypeArgument(AbstractDomainService.class, this.getClass(), (int)2);
    private M mapper;
    private REPOSITORY repository;

    @Transactional
    public DO create(DO domainObject) {
        Object entity = this.getMapper().toEntity(domainObject);
        entity = this.repository.merge(entity);
        domainObject.setId((Object)entity.getId());
        return domainObject;
    }

    @Transactional
    public void delete(DO domainObject) {
        Object entity = this.getMapper().toEntity(domainObject);
        this.repository.delete(entity);
    }

    @Transactional
    public DO delete(PK id) {
        BaseEntity entity = this.repository.get(id);
        DomainObject domainObject = (DomainObject)this.getMapper().toDomainObject((BaseEntity)entity);
        this.repository.delete(id);
        return (DO)domainObject;
    }

    public boolean exists(PK id) {
        return this.repository.exists(id);
    }

    public List<DO> findAll() {
        List all = this.repository.findAll();
        ArrayList domainObjects = new ArrayList();
        for (BaseEntity entity : all) {
            domainObjects.add(this.getMapper().toDomainObject((BaseEntity)entity));
        }
        return domainObjects;
    }

    @Transactional
    public Collection<PK> persist(Collection<DO> domainObjects) {
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        for (DomainObject domainObject : domainObjects) {
            primaryKeys.add(this.create(domainObject).getId());
        }
        return primaryKeys;
    }

    public DO read(PK id) {
        BaseEntity entity = this.repository.get(id);
        DomainObject domainObject = (DomainObject)this.getMapper().toDomainObject((BaseEntity)entity);
        return (DO)domainObject;
    }

    @Transactional
    public DO update(DO domainObject) {
        BaseEntity dbEntity = this.repository.get((Serializable)domainObject.getId());
        Object entity = this.getMapper().toEntity(domainObject);
        MergeObjectExtensions.merge((Object)dbEntity, entity);
        entity = this.repository.merge(entity);
        return domainObject;
    }

    public Class<DO> getDomainObjectClass() {
        return this.domainObjectClass;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    public M getMapper() {
        return this.mapper;
    }

    public void setRepository(REPOSITORY repository) {
        this.repository = repository;
    }

    public REPOSITORY getRepository() {
        return this.repository;
    }
}

