/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.collections.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

import lombok.Getter;

/**
 * An Iterator for an Array.
 * 
 * @author Asterios Raptis
 * @param <E>
 *            Generic type of this {@link ArrayIterator}
 */
public class ArrayIterator<E> implements Iterator<E>
{
	/**
	 * The array.
	 */
	@Getter
	private final E[] array;

	/**
	 * The position.
	 */
	private int pos = 0;

	/**
	 * Default constructor.
	 * 
	 * @param array
	 *            The array to iterate.
	 */
	public ArrayIterator(final E[] array)
	{
		this.array = array;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean hasNext()
	{
		return !(this.pos >= this.array.length || this.array[this.pos] == null);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public E next() throws NoSuchElementException
	{
		E next;
		try
		{
			next = this.array[this.pos];
		}
		catch (final RuntimeException e)
		{
			throw new NoSuchElementException("");
		}
		this.pos = this.pos + 1;
		return next;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void remove()
	{
		if (this.pos <= 0)
		{
			throw new IllegalStateException("The method next() was not invoked.");
		}
		if (this.array[this.pos - 1] != null)
		{
			for (int i = this.pos - 1; i < this.array.length - 1; i++)
			{
				this.array[i] = this.array[i + 1];
			}
			this.array[this.array.length - 1] = null;
		}
	}
}
