/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.collections.iterators;

import java.util.Iterator;

/**
 * Utility class for the use of Iterator objects.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public class IteratorUtils
{

	/**
	 * Helper method for printing the content from an Iterator.
	 * 
	 * @param <T>
	 *            the generic type
	 * @param iterator
	 *            The Iterator to print.
	 */
	public static <T> void printIterator(final Iterator<T> iterator)
	{
		int i = 1;
		while (iterator.hasNext())
		{
			final T element = iterator.next();
			System.out.println(i + ".)Element:" + element);
			i++;
		}
	}

}
