/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.collections.modifications;

import java.util.ArrayList;
import java.util.Collection;

import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * The Class ModifiedLists holds two collections. It is used as return type for finding from an old
 * list which elements have removed and which have added.
 *
 * @param <T>
 *            the generic type of the collections
 */
@NoArgsConstructor
public class ModifiedCollections<T>
{

	/** The added elements. */
	@Getter
	private final Collection<T> addedElements = new ArrayList<>();

	/** The removed elements. */
	@Getter
	private final Collection<T> removedElements = new ArrayList<>();

	/**
	 * Gets the modified lists.
	 *
	 * @param previous
	 *            the previous
	 * @param next
	 *            the next
	 * @return the modified lists
	 */
	public ModifiedCollections<T> getModifiedLists(Collection<T> previous, Collection<T> next)
	{
		// find the elements that are new...
		for (T added : next)
		{
			// elements from the previous list that are not exist in the next
			// list are new,
			// so added to the addedElements list...
			if (!previous.contains(added))
			{
				getAddedElements().add(added);
			}
		}
		// find the elements that are removed...
		for (T removed : previous)
		{
			// elements from the next list that are not exist in the previous
			// list are removed,
			// so added to the removedElements list...
			if (!next.contains(removed))
			{
				getRemovedElements().add(removed);
			}
		}
		return this;
	}

}
