/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.comparators;

import java.io.Serializable;
import java.util.Comparator;

/**
 * The Class ComparableComparator.
 *
 * @param <T>
 *            the generic type of the comparing object
 */
public class ComparableComparator<T extends Comparable<T>> implements Comparator<T>, Serializable
{
	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = -3825032779774158903L;

	/**
	 * Instantiates a new comparable comparator.
	 */
	public ComparableComparator()
	{
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int compare(T object, T compareWithObject)
	{
		return ComparatorUtils.compare(object, compareWithObject);
	}

}
