/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.comparators;

import java.util.Comparator;
import java.util.Date;

/**
 * The Class DescendingDateComparator sorts Date object in descending order.
 */
public class DescendingDateComparator implements Comparator<Date>
{

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int compare(Date date, Date compareWithDate)
	{
		return new DateComparator().compare(date, compareWithDate) * -1;
	}

}
