/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * The Class DefaultKeySetMap is the default implematation from the inteface
 * KeySetMap. It wrappes a Map with a key and values. The values are Sets. So
 * you can put in one key more unique values.
 * @param <K> Generic key parameter
 * @param <V> Generic value parameter
 * Note: will be removed in next version.
 */
@Deprecated
public class DefaultKeySetMap<K, V> implements KeySetMap<K, V> {

	/** Contains all entries in a List. */
	private final Map<K, Set<V>> entries = new HashMap<>();

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#add(Object, Object)
	 */
	@Override
	public void add(final K key, final V value) {
		Set<V> values = this.entries.get(key);
		if (null == values) {
			values = new HashSet<>();
			this.entries.put(key, values);
		}
		values.add(value);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#add(java.util.Map)
	 */
	@Override
	public void add(final Map<? extends K, ? extends Set<V>> keyListMap) {
		this.entries.putAll(keyListMap);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#containsKey(Object)
	 */
	@Override
	public boolean containsKey(final K key) {
		return this.entries.containsKey(key);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#get(Object)
	 */
	@Override
	public Set<V> get(final K key) {
		return this.entries.get(key);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#getKeys()
	 */
	@Override
	public Set<K> getKeys() {
		return this.entries.keySet();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#getSize()
	 */
	@Override
	public int getSize() {
		return this.entries.size();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return this.entries.isEmpty();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#remove(Object)
	 */
	@Override
	public Set<V> remove(final K key) {
		return this.entries.remove(key);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see net.sourceforge.jaulp.collections.KeySetMap#removeAll(java.util.Collection)
	 */
	@Override
	public void removeAll(final Collection<K> keys) {
		for (final K key : keys) {
			this.remove(key);
		}
	}

}
