/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * The Interface KeySetMap. It wrappes a Map with a key and values. The values
 * are Sets. So you can put in one key more unique values.
 * Note: will be removed in next version.
 * @param <K> the type of keys maintained by this map
 * @param <V> the type of mapped values * 
 */
@Deprecated
public interface KeySetMap<K, V> {

	/**
	 * Adds the value in the Set from the key.
	 * 
	 * @param key
	 *            the key
	 * @param value
	 *            the value
	 */
	void add(K key, V value);

	/**
	 * Adds a Map to the main Map.
	 * 
	 * @param keyListMap
	 *            the key list map
	 */
	void add(Map<? extends K, ? extends Set<V>> keyListMap);

	/**
	 * Contains key.
	 * 
	 * @param key
	 *            the key
	 * @return true, if successful
	 */
	boolean containsKey(K key);

	/**
	 * Gets the Set with the values from the given key.
	 * 
	 * @param key
	 *            the key
	 * @return the set< v>
	 */
	Set<V> get(K key);

	/**
	 * Gets the keys.
	 * 
	 * @return the keys
	 */
	Set<K> getKeys();

	/**
	 * Gets the size.
	 * 
	 * @return the size
	 */
	int getSize();

	/**
	 * Checks if is empty.
	 * 
	 * @return true, if is empty
	 */
	boolean isEmpty();

	/**
	 * Removes the Set from the given key.
	 * 
	 * @param key
	 *            the key
	 * @return the set< v>
	 */
	Set<V> remove(K key);

	/**
	 * Removes all keys from the Map from the given Collection.
	 * 
	 * @param keys
	 *            the keys
	 */
	void removeAll(Collection<K> keys);

}