/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.collections;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/**
 * The Class SortedProperties extends Properties and adds sort functionality for
 * the keys.
 */
public class SortedProperties extends Properties {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized Enumeration<Object> keys() {
		return Collections.enumeration(new TreeSet<Object>(super.keySet()));
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Set<Object> keySet() {
		return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Enumeration<?> propertyNames() {
		return Collections.enumeration(new TreeSet<Object>(super.keySet()));
	}
}
