/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.collections.iterators;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * The adapter class EnumerationIterator.
 *
 * @version 1.0
 * @author Asterios Raptis
 * @param <T> Generic type of this {@link EnumerationIterator}
 */
public class EnumerationIterator<T> implements Iterator<T> {

	/** The enumeration. */
	private Enumeration<T> enumeration;

	/**
	 * Instantiates a new enumeration iterator.
	 *
	 * @param enumeration
	 *            the enumeration to iterate.
	 */
	public EnumerationIterator(final Enumeration<T> enumeration) {
		super();
		this.enumeration = enumeration;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @return true, if checks for next
	 * @see java.util.Iterator#hasNext()
	 */
	@Override
	public boolean hasNext() {
		return this.enumeration.hasMoreElements();
	}

	/**
	 * {@inheritDoc}
	 *
	 * @return the object
	 * @see java.util.Iterator#next()
	 */
	@Override
	public T next() {
		return this.enumeration.nextElement();
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see java.util.Iterator#remove()
	 */
	@Override
	public void remove() {
		throw new UnsupportedOperationException(
				"The method remove is not supported in this Version.");
	}

}
