/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.comparators;

/**
 * The Class ComparatorUtils have helper methods for comparators.
 */
public class ComparatorUtils {
	
	/**
	 * Checks if one of the given objects is null and returns the value for the Comparator or null if both are not null or if the given objects are not the same Object.
	 *
	 * @param <T> the generic type
	 * @param object the object
	 * @param compareWithObject the compare with object
	 * @return the integer
	 */
	public static <T> Integer nullCheck(T object, T compareWithObject) {
		// Check if one of the objects are null
		if ((object != null) && (compareWithObject == null)) {
			return 1;// compareWithObject is null so its bigger
		}  
		if ((object == null) && (compareWithObject != null)) {
			return -1; // object is null so its smaller
		}  
		if (object == compareWithObject) {
			return 0;// it is the same Object
		}
		return null;		
	}
	
	/**
	 * Compares the given objects and returns the int value.
	 *
	 * @param <T> the generic type
	 * @param object the object
	 * @param compareWithObject the compare with object
	 * @return the int
	 */
	public static <T extends Comparable<T>> int compare(T object, T compareWithObject) {
		Integer nc = ComparatorUtils.nullCheck(object, compareWithObject);
		if(nc != null) {
			return nc;
		}
		// Null check completed so we can compare the objects
		return object.compareTo(compareWithObject);
		
	}

}
