/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.comparators;

import java.io.Serializable;
import java.util.Comparator;

/**
 * This class compare two Objects by the hashcode.
 *
 * @param <T>
 *            the < t>
 * @version 1.0
 * @author Asterios Raptis
 */
public class HashCodeComparator<T> implements Comparator<T>, Serializable {

	/**
	 * The generated serialVersionUID.
	 */
	private static final long serialVersionUID = -6270968560769922192L;

	/**
	 * Compare two Objects by the hashcode.
	 *
	 * @param object
	 *            One Object.
	 * @param compareWithObject
	 *            The other Object to compare.
	 * @return the result.
	 * @see java.util.Comparator#compare(Object, Object)
	 */
	@Override
	public int compare(final T object, final T compareWithObject) {
		Integer nc = ComparatorUtils.nullCheck(object, compareWithObject);
		if(nc != null) {
			return nc;
		}
		// compare the two hashCodes from the objects
		final int hashCodeOjbect = object.hashCode();
		final int hashCodeCompareWithObject = compareWithObject.hashCode();
		if (hashCodeOjbect > hashCodeCompareWithObject) {
			return 1; // bigger
		}  
		if (hashCodeOjbect < hashCodeCompareWithObject) {
			return -1; // smaller
		}
		if (hashCodeOjbect == hashCodeCompareWithObject) {
			return 0; // same hashcode
		}
		return 0;		
	}

}
