/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.email.messages;

/**
 * The Class EmailConstants for constants.
 */
public abstract class EmailConstants
{

	/** Constant for the charset-prefix. */
	public static final String CHARSET_PREFIX = "; charset=";

	/** Constant for the charset 'UTF-8'. */
	public static final String CHARSET_UTF8 = "UTF-8";

	/** Constant for the name from the properties-file. */
	public static final String PROPERTIES_FILENAME = "mail.properties";

	/** Constant for the mimetype text/html. */
	public static final String MIMETYPE_TEXT_HTML = "text/html";

	/** Constant for the mimetype text/plain. */
	public static final String MIMETYPE_TEXT_PLAIN = "text/plain";

}