/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.email.messages;

import de.alpharogroup.email.data.sources.ByteArrayDataSource;
import de.alpharogroup.email.messages.EmailMessage;
import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class EmailWithAttachments
extends EmailMessage {
    private static final long serialVersionUID = 1L;
    private final MimeMultipart mimeMultiPart = new MimeMultipart();

    public EmailWithAttachments() throws MessagingException {
        this.setContent((Multipart)this.mimeMultiPart);
    }

    public void addAttachment(BodyPart part) throws MessagingException {
        this.getMimeMultiPart().addBodyPart(part);
    }

    public void addAttachment(byte[] content, String filename, String mimetype) throws MessagingException {
        ByteArrayDataSource dataSource = new ByteArrayDataSource(content, mimetype);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        this.addAttachment(dataHandler, filename);
    }

    public void addAttachment(DataHandler handler, String filename) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setFileName(filename);
        part.setDataHandler(handler);
        this.addAttachment((BodyPart)part);
    }

    public void addAttachment(File file) throws MessagingException {
        FileDataSource dataSource = new FileDataSource(file);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        this.addAttachment(dataHandler, file.getName());
    }

    public void addAttachment(File file, String newFilename) throws MessagingException {
        FileDataSource dataSource = new FileDataSource(file);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        this.addAttachment(dataHandler, newFilename);
    }

    public synchronized MimeMultipart getMimeMultiPart() throws MessagingException {
        return this.mimeMultiPart;
    }
}

