/**
 * The MIT License
 *
 * Copyright (C) 2007 Asterios Raptis
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package de.alpharogroup.swing.panels.login;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import de.alpharogroup.generic.mvc.controller.AbstractGenericController;

public class LoginController extends AbstractGenericController<LoginModel, LoginView>
	implements
		WindowListener
{

	private LoginPanel loginPanel;

	private final LoginDialog dialog;

	public LoginController(LoginDialog dialog)
	{
		super();
		this.dialog = dialog;
		this.dialog.addWindowListener(this);
	}

	@Override
	protected void preinitialize()
	{
		setModel(new LoginModel());
		super.preinitialize();
	}

	@Override
	public void process(ActionEvent actionEvent)
	{
		if (null == loginPanel)
		{
			loginPanel = getView().getComponent();
		}
		if (actionEvent.getSource() == getView().getComponent().getBtnLogin())
		{

			LoginModel model = getModel();
			model.getModelObject().setUsername(getView().getComponent().getTxtUsername().getText());
			String pw = new String(getView().getComponent().getTxtPassword().getPassword());
			model.getModelObject().setPassword(pw);
			// AuthorisationService authorisationService = new AuthorisationServiceImpl();
			// Users user = authorisationService.authenticateUser( getModel() );
			// if(null != user){
			// this.dialog.dispose();
			// MainFrame.getInstance().setVisible( true );
			// } else {
			// getView().getComponent().getTxtInfo().setForeground( Color.RED );
			// loginPanel.getTxtInfo().setText( "Access denied!" );
			// loginPanel.getTxtUsername().setText( "" );
			// loginPanel.getTxtPassword().setText( "" );
			// }

		}
		else if (actionEvent.getSource() == loginPanel.getBtnCancel())
		{
			System.exit(0);
		}

	}

	protected LoginView getLoginView()
	{
		return getView();

	}

	protected LoginPanel getLoginPanel()
	{
		return getView().getComponent();
	}

	protected LoginModel getLoginModel()
	{
		return getModel();
	}


	@Override
	public void windowOpened(WindowEvent e)
	{
	}

	@Override
	public void windowClosing(WindowEvent e)
	{
	}

	@Override
	public void windowClosed(WindowEvent e)
	{
	}

	@Override
	public void windowIconified(WindowEvent e)
	{
	}

	@Override
	public void windowDeiconified(WindowEvent e)
	{
	}

	@Override
	public void windowActivated(WindowEvent e)
	{
	}

	@Override
	public void windowDeactivated(WindowEvent e)
	{
	}

}