/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.generic.mvc.view;

import de.alpharogroup.generic.mvc.view.View;
import java.awt.Component;

public abstract class AbstractGenericView<C, COMP extends Component>
implements View<C, COMP> {
    private COMP component;
    private C controller;
    private View<C, COMP> parent;

    public AbstractGenericView(C controller) {
        this.controller = controller;
        this.initialize();
    }

    protected abstract void initialize();

    @Override
    public COMP getComponent() {
        return this.component;
    }

    @Override
    public C getController() {
        return this.controller;
    }

    @Override
    public View<C, COMP> getParent() {
        return this.parent;
    }

    public View<?, ?> getRootParentView() {
        View<Object, Object> currentView = this;
        while (currentView.hasParent()) {
            currentView = currentView.getParent();
        }
        return currentView;
    }

    @Override
    public boolean hasParent() {
        return null != this.parent;
    }

    @Override
    public void setComponent(COMP component) {
        this.component = component;
    }

    @Override
    public void setController(C controller) {
        this.controller = controller;
    }

    public void setParent(View<C, COMP> parent) {
        this.parent = parent;
    }
}

