/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.JComponent;

public class DrawMessage
extends JComponent {
    private static final long serialVersionUID = 1482171136672852023L;
    private Color color;
    private String message = null;

    public DrawMessage(String message, Color color) {
        this.message = message;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(150, 5);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 16);
    }

    private Graphics2D initGraphics2D(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setColor(this.color);
        return g2;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = this.initGraphics2D(g);
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = new Font("Arial", 1, 16);
        String display = new String(this.message.getBytes());
        TextLayout textLayout = new TextLayout(display, font, frc);
        Dimension dimension = this.getSize();
        textLayout.draw(g2, 0.0f, dimension.height);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

