/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing;

import de.alpharogroup.swing.GenericJTable;

public class GenericShuffleJTable<T> {
    private final GenericJTable<T> leftTable;
    private final GenericJTable<T> rightTable;

    public GenericShuffleJTable(GenericJTable<T> leftTable, GenericJTable<T> rightTable) {
        this.leftTable = leftTable;
        this.rightTable = rightTable;
    }

    public void addAllLeftRowsToRightTable() {
        this.rightTable.getGenericTableModel().addList(this.leftTable.getGenericTableModel().getData());
        this.leftTable.getGenericTableModel().clear();
    }

    public void addAllRightRowsToLeftTable() {
        this.leftTable.getGenericTableModel().addList(this.rightTable.getGenericTableModel().getData());
        this.rightTable.getGenericTableModel().clear();
    }

    public void shuffleSelectedLeftRowsToRightTable() {
        int lastIndex;
        int[] selectedRows = this.leftTable.getSelectedRows();
        for (int i = lastIndex = selectedRows.length - 1; -1 < i; --i) {
            int selectedRow = selectedRows[i];
            T row = this.leftTable.getGenericTableModel().removeAt(selectedRow);
            this.rightTable.getGenericTableModel().add(row);
        }
    }

    public void shuffleSelectedRightRowsToLeftTable() {
        int lastIndex;
        int[] selectedRows = this.rightTable.getSelectedRows();
        for (int i = lastIndex = selectedRows.length - 1; -1 < i; --i) {
            int selectedRow = selectedRows[i];
            T row = this.rightTable.getGenericTableModel().removeAt(selectedRow);
            this.leftTable.getGenericTableModel().add(row);
        }
    }

    public void shuffleSelectedLeftRowToRightTable() {
        int selectedRow = this.leftTable.getSelectedRow();
        T row = this.leftTable.getGenericTableModel().removeAt(selectedRow);
        this.rightTable.getGenericTableModel().add(row);
    }

    public void shuffleSelectedRightRowToLeftTable() {
        int selectedRow = this.rightTable.getSelectedRow();
        T row = this.rightTable.getGenericTableModel().removeAt(selectedRow);
        this.leftTable.getGenericTableModel().add(row);
    }
}

