/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.browser;

import java.util.regex.Pattern;

public enum OS {
    WINDOWS("Windows"),
    MAC("Mac OS"),
    LINUX("Linux"),
    UNIX("Unix"),
    OTHER("Other");

    private static final String OS_NAME = "os.name";
    private static final Pattern LINUX_PATTERN;
    private static final Pattern WINDOWS_PATTERN;
    private final String os;

    public String getOs() {
        return this.os;
    }

    private OS(String os) {
        this.os = os;
    }

    public OS getOperatingSystem() {
        String osname = System.getProperty(OS_NAME);
        if (WINDOWS_PATTERN.matcher(osname).matches()) {
            return WINDOWS;
        }
        if (LINUX_PATTERN.matcher(osname).matches()) {
            return LINUX;
        }
        return OTHER;
    }

    static {
        LINUX_PATTERN = Pattern.compile(".*[L|l]inux.*");
        WINDOWS_PATTERN = Pattern.compile(".*[W|w]indows.*");
    }
}

