/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.tablemodel;

import de.alpharogroup.swing.tablemodel.GenericTableModel;

public class GenericShuffleTableModel<T> {
    private final GenericTableModel<T> leftTableModel;
    private final GenericTableModel<T> rightTableModel;

    public GenericShuffleTableModel(GenericTableModel<T> leftTableModel, GenericTableModel<T> rightTableModel) {
        this.leftTableModel = leftTableModel;
        this.rightTableModel = rightTableModel;
    }

    public void addAllLeftRowsToRightTableModel() {
        this.rightTableModel.addList(this.leftTableModel.getData());
        this.leftTableModel.clear();
    }

    public void addAllRightRowsToLeftTableModel() {
        this.leftTableModel.addList(this.rightTableModel.getData());
        this.rightTableModel.clear();
    }

    public void shuffleSelectedLeftRowsToRightTableModel(int[] selectedRows) {
        int lastIndex;
        for (int i = lastIndex = selectedRows.length - 1; -1 < i; --i) {
            int selectedRow = selectedRows[i];
            T row = this.leftTableModel.removeAt(selectedRow);
            this.rightTableModel.add(row);
        }
    }

    public void shuffleSelectedLeftRowToRightTableModel(int selectedRow) {
        T row = this.leftTableModel.removeAt(selectedRow);
        this.rightTableModel.add(row);
    }

    public void shuffleSelectedRightRowsToLeftTableModel(int[] selectedRows) {
        int lastIndex;
        for (int i = lastIndex = selectedRows.length - 1; -1 < i; --i) {
            int selectedRow = selectedRows[i];
            T row = this.rightTableModel.removeAt(selectedRow);
            this.leftTableModel.add(row);
        }
    }

    public void shuffleSelectedRightRowToLeftTableModel(int selectedRow) {
        T row = this.rightTableModel.removeAt(selectedRow);
        this.leftTableModel.add(row);
    }
}

