/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.img;

import de.alpharogroup.io.StreamUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;

public class ImageUtils {
    public static BufferedImage concatenateImages(List<BufferedImage> imgCollection, int width, int height, int imageType, Direction concatenationDirection) {
        BufferedImage img = new BufferedImage(width, height, imageType);
        int x = 0;
        int y = 0;
        for (BufferedImage bi : imgCollection) {
            boolean imageDrawn = img.createGraphics().drawImage((Image)bi, x, y, null);
            if (!imageDrawn) {
                throw new RuntimeException("BufferedImage could not be drawn:" + bi.toString());
            }
            if (concatenationDirection.equals((Object)Direction.vertical)) {
                y += bi.getHeight();
                continue;
            }
            x += bi.getWidth();
        }
        return img;
    }

    public static BufferedImage getResized(BufferedImage originalImage, Scalr.Method scalingMethod, Scalr.Mode resizeMode, String formatName, int targetWidth, int targetHeight) throws IOException {
        return ImageUtils.read(ImageUtils.resize(originalImage, scalingMethod, resizeMode, formatName, targetWidth, targetHeight));
    }

    public static BufferedImage getResized(BufferedImage originalImage, String formatName, int targetWidth, int targetHeight) throws IOException {
        return ImageUtils.read(ImageUtils.resize(originalImage, formatName, targetWidth, targetHeight));
    }

    public static BufferedImage read(byte[] byteArray) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(byteArray));
    }

    public static byte[] resize(BufferedImage originalImage, Scalr.Method scalingMethod, Scalr.Mode resizeMode, String formatName, int targetWidth, int targetHeight) {
        try {
            BufferedImage resizedImage = Scalr.resize((BufferedImage)originalImage, (Scalr.Method)scalingMethod, (Scalr.Mode)resizeMode, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[0]);
            return ImageUtils.toByteArray(resizedImage, formatName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] resize(BufferedImage originalImage, String formatName, int targetWidth, int targetHeight) {
        return ImageUtils.resize(originalImage, Scalr.Method.QUALITY, Scalr.Mode.FIT_EXACT, formatName, targetWidth, targetHeight);
    }

    public static byte[] toByteArray(BufferedImage bi, String formatName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] byteArray;
            ImageIO.write((RenderedImage)bi, formatName, baos);
            baos.flush();
            byte[] byArray = byteArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            StreamUtils.close((OutputStream)baos);
        }
    }

    public static String unweaveFrom(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int messageLength = bufferedImage.getRGB(0, 0) & 0xFF;
        StringBuilder sb = new StringBuilder();
        int j = 0;
        int i = 1;
        for (int row = 0; row < height; ++row) {
            int column = 0;
            while (column < width && j < messageLength) {
                if (i % 11 == 0) {
                    int result = bufferedImage.getRGB(column, row);
                    int charAtPosition = (result >> 16 & 7) << 5;
                    charAtPosition |= (result >> 8 & 7) << 2;
                    sb.append((char)(charAtPosition |= result & 3));
                    ++j;
                }
                ++column;
                ++i;
            }
        }
        return sb.toString();
    }

    public static BufferedImage weaveInto(BufferedImage bufferedImage, String message) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (message.length() > 255) {
            throw new IllegalArgumentException("Given message is to large(max 255 characters)");
        }
        if (message.length() * 11 > width * height) {
            throw new IllegalArgumentException("Given image is to small");
        }
        byte[] messageBytes = message.getBytes();
        int messageLengthDecode = bufferedImage.getRGB(0, 0) >> 8 << 8;
        bufferedImage.setRGB(0, 0, messageLengthDecode |= message.length());
        int i = 1;
        int messagePosition = 0;
        int j = 0;
        for (int row = 0; row < height; ++row) {
            int column = 0;
            while (column < width && j < messageBytes.length) {
                if (i % 11 == 0) {
                    int rgb = bufferedImage.getRGB(column, row);
                    int a = rgb >> 24 & 0xFF;
                    int r = (rgb >> 16 & 0xFF) >> 3 << 3;
                    int g = (rgb >> 8 & 0xFF) >> 3 << 3;
                    int b = (rgb & 0xFF) >> 2 << 2;
                    rgb = 0;
                    rgb |= a << 24;
                    rgb |= (r |= messageBytes[messagePosition] >> 5) << 16;
                    rgb |= (g |= messageBytes[messagePosition] >> 2 & 7) << 8;
                    bufferedImage.setRGB(column, row, rgb |= (b |= messageBytes[messagePosition] & 3));
                    ++messagePosition;
                    ++j;
                }
                ++column;
                ++i;
            }
        }
        return bufferedImage;
    }

    public static enum Direction {
        horizontal,
        vertical;

    }
}

