/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.treemodel;

import de.alpharogroup.swing.treemodel.ifaces.ITreeNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGenericTreeNode<T>
implements ITreeNode<T> {
    private List<ITreeNode<T>> children;
    private T value;

    public AbstractGenericTreeNode() {
    }

    public AbstractGenericTreeNode(T value) {
        this();
        this.setValue(value);
    }

    @Override
    public void addChild(ITreeNode<T> child) {
        if (this.children != null) {
            this.children.add(child);
        } else {
            this.children = new ArrayList<ITreeNode<T>>();
            this.children.add(child);
        }
    }

    @Override
    public void addChildAt(int index, ITreeNode<T> child) throws IndexOutOfBoundsException {
        if (this.children != null && this.children.size() < index) {
            this.children.add(index, child);
        } else {
            this.addChild(child);
        }
    }

    @Override
    public boolean equals(ITreeNode<T> treeNode) {
        return treeNode.getValue().equals(treeNode);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public List<ITreeNode<T>> getChildren() {
        if (this.children == null) {
            return new ArrayList<ITreeNode<T>>();
        }
        return this.children;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren() != null && !this.getChildren().isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean isLeaf() {
        return !this.isNode();
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public void removeChild(ITreeNode<T> child) {
        if (this.children != null) {
            this.children.remove(child);
        } else {
            this.children = new ArrayList<ITreeNode<T>>();
        }
    }

    @Override
    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    @Override
    public void setChildren(List<ITreeNode<T>> children) {
        this.children = children;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public List<ITreeNode<T>> toList() {
        ArrayList<ITreeNode<T>> list = new ArrayList<ITreeNode<T>>();
        this.traverse(this, list);
        return list;
    }

    @Override
    public void traverse(ITreeNode<T> node, List<ITreeNode<T>> list) {
        list.add(node);
        for (ITreeNode<T> data : node.getChildren()) {
            this.traverse(data, list);
        }
    }
}

