/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaulp.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jaulp.date.DatePatterns;

public class ParseDateUtils
implements DatePatterns {
    public static Date parseDate(String date, List<String> patterns) {
        for (String pattern : patterns) {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            try {
                Date result = formatter.parse(date);
                return result;
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static Date parseToDate(String date, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date parsedDate = null;
        parsedDate = df.parse(date);
        return parsedDate;
    }

    public static Date parseToDate(String datum, String[] formats, Locale locale) {
        for (String format : formats) {
            SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
            try {
                return sdf.parse(datum);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static Date parseToDateLenient(String date, String format, boolean lenient) {
        if (date == null || format == null || format.length() <= 0) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setLenient(lenient);
        Date parsedDate = null;
        try {
            parsedDate = df.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedDate;
    }

    public static String parseToString(Date date, String format) {
        return ParseDateUtils.parseToString(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static String parseToString(Date date, String format, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(format, locale);
        String result = df.format(date);
        return result;
    }

    public static String parseToString(String date, String currentformat, String newFormat) throws ParseException {
        Date currentDate = ParseDateUtils.parseToDate(date, currentformat);
        String result = ParseDateUtils.parseToString(currentDate, newFormat);
        return result;
    }

    private ParseDateUtils() {
    }
}

