/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.date;

import de.alpharogroup.date.Age;
import de.alpharogroup.date.CreateDateUtils;
import de.alpharogroup.date.DatePatterns;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CalculateDateUtils
implements DatePatterns {
    public static Date addMilliseconds(Date date, int addMilliseconds) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(14, addMilliseconds);
        return dateOnCalendar.getTime();
    }

    public static Date addSeconds(Date date, int addSeconds) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(13, addSeconds);
        return dateOnCalendar.getTime();
    }

    public static Date addMinutes(Date date, int addMinutes) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(12, addMinutes);
        return dateOnCalendar.getTime();
    }

    public static Date addHours(Date date, int addHours) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(10, addHours);
        return dateOnCalendar.getTime();
    }

    public static Date addDays(Date date, int addDays) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(5, addDays);
        return dateOnCalendar.getTime();
    }

    public static Date addWeeks(Date date, int addWeeks) {
        return CalculateDateUtils.addDays(date, addWeeks * 7);
    }

    public static Date addMonths(Date date, int addMonths) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(2, addMonths);
        return dateOnCalendar.getTime();
    }

    public static Date addYears(Date date, int addYears) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(1, addYears);
        return dateOnCalendar.getTime();
    }

    public static long calculateElapsedTime(Date past, Date now) {
        long elapsedTime = now.getTime() - past.getTime();
        return elapsedTime;
    }

    public static long calculateTimeFromNow(Date now, Date future) {
        long elapsedTime = future.getTime() - now.getTime();
        return elapsedTime;
    }

    public static int computeAge(Date birthday, Date computeDate) {
        long ageInLong = CalculateDateUtils.calculateElapsedTime(birthday, computeDate);
        Age age = new Age(ageInLong);
        return (int)age.calculateInYears();
    }

    public static Date computeEasternSunday(int year) {
        int easternSundayNumber = CalculateDateUtils.computeEasternSundayNumber(year);
        int month = easternSundayNumber / 31;
        int day = easternSundayNumber % 31 + 1;
        return CreateDateUtils.newDate(year, month - 1, day);
    }

    public static int computeEasternSundayNumber(int year) {
        int i = year % 19;
        int j = year / 100;
        int k = year % 100;
        int l = (19 * i + j - j / 4 - (j - (j + 8) / 25 + 1) / 3 + 15) % 30;
        int m = (32 + 2 * (j % 4) + 2 * (k / 4) - l - k % 4) % 7;
        int n = l + m - 7 * ((i + 11 * l + 22 * m) / 451) + 114;
        return n;
    }

    public static boolean isBetween(Date start, Date end, Date between) {
        long min = start.getTime();
        long max = end.getTime();
        long index = between.getTime();
        return min <= index && index <= max;
    }

    public static boolean isDateInTheFuture(Date date) {
        return !CalculateDateUtils.isDateInThePast(date);
    }

    public static boolean isDateInThePast(Date date) {
        boolean inPast = false;
        Calendar compare = Calendar.getInstance();
        compare.setTime(date);
        Calendar now = Calendar.getInstance();
        now.setTime(new Date(System.currentTimeMillis()));
        inPast = now.after(compare);
        return inPast;
    }

    public static boolean before(Date point, Date when) {
        Calendar pointCalendar = Calendar.getInstance();
        pointCalendar.setTime(point);
        Calendar whenCalendar = Calendar.getInstance();
        whenCalendar.setTime(when);
        return pointCalendar.before(whenCalendar);
    }

    public static boolean after(Date point, Date when) {
        Calendar pointCalendar = Calendar.getInstance();
        pointCalendar.setTime(point);
        Calendar whenCalendar = Calendar.getInstance();
        whenCalendar.setTime(when);
        return pointCalendar.after(whenCalendar);
    }

    public static boolean isLeapYear(int year) {
        GregorianCalendar gc = new GregorianCalendar();
        return gc.isLeapYear(year);
    }

    public static boolean isValidDate(String date, String format, boolean lenient) {
        boolean isValid = true;
        if (date == null || format == null || format.length() <= 0) {
            return false;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setLenient(lenient);
        try {
            df.parse(date);
        }
        catch (ParseException e) {
            isValid = false;
        }
        return isValid;
    }

    public static Date substractDaysFromDate(Date date, int substractDays) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(5, substractDays * -1);
        return dateOnCalendar.getTime();
    }

    public static Date substractWeeksFromDate(Date date, int substractWeeks) {
        return CalculateDateUtils.substractDaysFromDate(date, substractWeeks * 7);
    }

    public static Date substractMonthsFromDate(Date date, int substractMonths) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(2, substractMonths * -1);
        return dateOnCalendar.getTime();
    }

    public static Date substractYearsFromDate(Date date, int substractYears) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(1, substractYears * -1);
        return dateOnCalendar.getTime();
    }

    private CalculateDateUtils() {
    }
}

