/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.date;

/**
 * Interface for Date-Patterns.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public interface DatePatterns {

    /**
     * Dateformat in String. Current value:"yyyy-MM-dd'T'HH:mm:ss"
     */
    public String YYYY_MM_DD_T_HH_MM_SS = "yyyy-MM-dd'T'HH:mm:ss";

    /**
     * Dateformat in String. Current value:"EEEE MMM dd, yyyy"
     */
    public String EEEE_MMM_DD_YYYY = "EEEE MMM dd, yyyy";

    /**
     * Dateformat in String. Current value:"dd-MMM-yy"
     */
    public String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd hh:mm:ss";

    /**
     * Dateformat in String. Current value:"dd-MMM-yy"
     */
    public String DD_MMM_YY = "dd-MMM-yy";

    /**
     * Dateformat in String. Current value:"yyyy.MM.dd.HH.mm.ss"
     */
    public String DOT_YYYY_MM_DD_HH_MM_SS = "yyyy.MM.dd.HH.mm.ss";

    /**
     * Dateformat in String. Current value:"EEE MMM dd hh:mm:ss z yyyy"
     */
    public String EEE_MMM_DD_HH_MM_SS_Z_YYYY = "EEE MMM dd hh:mm:ss z yyyy";

    /**
     * Dateformat in String. Current value:"yyyy-MM-dd hh:mm:ss.S"
     */
    public String YYYY_MM_DD_HH_MM_SS_S = "yyyy-MM-dd hh:mm:ss.S";

    /**
     * Dateformat in String. Current value:"dd.MM"
     */
    public String DOT_DD_MM = "dd.MM";

    /**
     * Dateformat in String. Current value:"yyyyMMddHHmmss"
     */
    public String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    /**
     * Dateformat in String. Current value:"HH:mm:ss"
     */
    public String UHH_MM_SS = "HH:mm:ss";

    /**
     * Dateformat in String. Current value:"HH:mm:ss"
     */
    public String UHH_MM = "HH:mm";

    /**
     * Dateformat in String. Current value:"hh:mm:ss"
     */
    public String LHH_MM_SS = "hh:mm:ss";

    /**
     * Dateformat in String. Current value:"dd.MM.yyyy"
     */
    public String DOT_DD_MM_YYYY = "dd.MM.yyyy";

    /**
     * Dateformat in String. Current value:"dd.MM.yyyy HH:mm:ss"
     */
    public String DOT_DD_MM_YYYY_HH_MM_SS = DOT_DD_MM_YYYY + " " + UHH_MM_SS;

    /**
     * Dateformat in String. Current
     * value:"yyyy-MM-dd"
     */
    public String YYYY_MM_DD = "yyyy-MM-dd";

    /**
     * Dateformat in String. Current value:"dd.MM.yy"
     */
    public String DOT_DD_MM_YY = "dd.MM.yy";

}