/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.date.comparators;

import java.util.Comparator;

import net.sourceforge.jaulp.date.Day;

/**
 * The Class DayComparator. It compares Day objects.
 */
public class DayComparator implements Comparator< Day > {

    /**
     * Compare.
     *
     * @param day the day
     * @param compareWithDay the compare with day
     * @return the int
     * {@inheritDoc}
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare( final Day day, final Day compareWithDay ) {
        return day.compareTo( compareWithDay );
    }

}
