/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.data.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SingleSortState;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jaulp.wicket.data.provider.SortCollectionUtils;

public class AbstractSortableDataProvider<T extends Serializable, S extends Serializable>
implements ISortableDataProvider<T, S> {
    private static final long serialVersionUID = 1L;
    private List<T> data;
    private final SingleSortState<S> sortState = new SingleSortState();

    public AbstractSortableDataProvider() {
        this(new ArrayList());
    }

    public AbstractSortableDataProvider(List<T> data) {
        this.data = data;
    }

    public final ISortState<S> getSortState() {
        return this.sortState;
    }

    public SortParam<S> getSort() {
        return this.sortState.getSort();
    }

    public void setSort(SortParam<S> param) {
        this.sortState.setSort(param);
    }

    public void setSort(S property, SortOrder order) {
        this.sortState.setPropertySortOrder(property, order);
    }

    public void detach() {
        this.data = null;
    }

    public List<T> getData() {
        return this.data;
    }

    public Iterator<? extends T> iterator(long first, long count) {
        List<Object> result = new ArrayList<T>(this.sort());
        result = (long)result.size() > first + count ? result.subList((int)first, (int)first + (int)count) : result.subList((int)first, result.size());
        return result.iterator();
    }

    protected List<T> sort(List<T> unsortedList) {
        SortParam<S> sortParam = this.getSort();
        if (sortParam != null) {
            String property = (String)sortParam.getProperty();
            boolean ascending = sortParam.isAscending();
            SortCollectionUtils.sortList(unsortedList, property, ascending);
        }
        return unsortedList;
    }

    protected List<T> sort() {
        return this.sort(this.getData());
    }

    public IModel<T> model(T object) {
        return Model.of(object);
    }

    protected void setData(List<T> data) {
        this.data = data;
    }

    public long size() {
        return this.getData().size();
    }
}

