/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.clone.object;

import com.rits.cloning.Cloner;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.NonNull;

public final class CloneObjectExtensions {
    private static final Cloner cloner = new Cloner();

    public static <T> T clone(T object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        return (T)CloneObjectExtensions.cloneObject(object);
    }

    public static Object cloneObject(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        if (object == null) {
            return object;
        }
        Object clone = null;
        if (object instanceof Cloneable) {
            clone = CloneObjectExtensions.cloneCloneable(object);
        }
        if (clone == null) {
            clone = CloneObjectExtensions.withCloner(object);
        }
        return clone;
    }

    public static <T> T withCloner(@NonNull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return (T)cloner.deepClone(object);
    }

    public static Object cloneCloneable(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (object.getClass().isArray()) {
            Object clone;
            Class<?> componentType = object.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(object);
                clone = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(clone, length, Array.get(object, length));
                }
            } else {
                clone = ((Object[])object).clone();
            }
            if (clone != null) {
                return clone;
            }
        }
        Class<?> clazz = object.getClass();
        Method cloneMethod = clazz.getDeclaredMethod("clone", new Class[0]);
        cloneMethod.setAccessible(true);
        return cloneMethod.invoke(object, (Object[])null);
    }

    private CloneObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

