/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.check;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public final class Check
implements Serializable {
    private static final Check instance = new Check();
    private static final long serialVersionUID = 1L;

    public static synchronized Check get() {
        return instance;
    }

    private Check() {
    }

    public Check isInRange(Double min, Double max, Double value, String name) {
        this.nullCheck(min, "min");
        this.nullCheck(max, "max");
        this.nullCheck(value, name);
        if (!(min < value) || !(value < max)) {
            throw new IllegalArgumentException(String.format("Given argument '%s' should have a value between %s - %s, but given argument is currently:%s", name, min, max, value));
        }
        return this;
    }

    public Check isInRange(Float min, Float max, Float value, String name) {
        this.nullCheck(min, "min");
        this.nullCheck(max, "max");
        this.nullCheck(value, name);
        if (!(min.floatValue() < value.floatValue()) || !(value.floatValue() < max.floatValue())) {
            throw new IllegalArgumentException(String.format("Given argument '%s' should have a value between %s - %s, but given argument is currently:%s", name, min, max, value));
        }
        return this;
    }

    public Check isInRange(Integer min, Integer max, Integer value, String name) {
        this.nullCheck(min, "min");
        this.nullCheck(max, "max");
        this.nullCheck(value, name);
        if (min >= value || value >= max) {
            throw new IllegalArgumentException(String.format("Given argument '%s' should have a value between %s - %s, but given argument is currently:%s", name, min, max, value));
        }
        return this;
    }

    public Check isInRange(Long min, Long max, Long value, String name) {
        this.nullCheck(min, "min");
        this.nullCheck(max, "max");
        this.nullCheck(value, name);
        if (min >= value || value >= max) {
            throw new IllegalArgumentException(String.format("Given argument '%s' should have a value between %s - %s, but given argument is currently:%s", name, min, max, value));
        }
        return this;
    }

    public <T, C extends Collection<T>> Check notEmpty(C collection, String name) {
        this.nullCheck(collection, name);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Given collection '" + name + "' may not be empty.");
        }
        return this;
    }

    public <K, V, M extends Map<K, V>> Check notEmpty(M map, String name) {
        this.nullCheck(map, name);
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Given map '" + name + "' may not be empty.");
        }
        return this;
    }

    public <T extends CharSequence> Check notEmpty(T argument, String name) {
        this.nullCheck(argument, name);
        if (argument.length() == 0 || argument.toString().trim().length() == 0) {
            throw new IllegalArgumentException("Given argument '" + name + "' may not be empty.");
        }
        return this;
    }

    public <T> Check notNull(T argument, String name) {
        this.nullCheck(argument, name);
        return this;
    }

    private <T> void nullCheck(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Given argument '" + name + "' may not be null.");
        }
    }
}

