/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.lang.ClassType;
import de.alpharogroup.lang.PackageExtensions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class ClassExtensions {
    protected static final String CGLIB_TAG = "$$";

    public static Class<?> forName(@NonNull String className) throws ClassNotFoundException {
        Class<?> clazz;
        block3: {
            if (className == null) {
                throw new NullPointerException("className is marked @NonNull but is null");
            }
            clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable throwable) {
                clazz = Class.forName(className, true, ClassExtensions.getClassLoader());
                if (clazz != null || (clazz = Class.forName(className, false, ClassExtensions.getClassLoader())) != null) break block3;
                throw throwable;
            }
        }
        return clazz;
    }

    public static Class<?> getBaseClass(Class<?> childClass) {
        if (childClass == null || childClass.equals(Object.class)) {
            return childClass;
        }
        Class<?> superClass = childClass.getSuperclass();
        if (superClass != null && superClass.equals(Object.class)) {
            return childClass;
        }
        while (superClass.getSuperclass() == null || !superClass.getSuperclass().equals(Object.class)) {
            superClass = superClass.getSuperclass();
        }
        return superClass;
    }

    public static String getCallingMethodName(@NonNull StackTraceElement[] elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        String callingMethodName = null;
        if (2 < elements.length) {
            StackTraceElement element = elements[2];
            callingMethodName = element.getMethodName();
        }
        return callingMethodName;
    }

    public static Class<?> getCglibProxy(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        Class<?> found = clazz;
        while (ClassExtensions.isCglib(found)) {
            found = found.getSuperclass();
        }
        return found;
    }

    public static <T> Class<T> getClass(T object) {
        if (object != null) {
            return object.getClass();
        }
        return null;
    }

    public static ClassLoader getClassLoader() {
        return ClassExtensions.getClassLoader(null);
    }

    public static ClassLoader getClassLoader(Object obj) {
        ClassLoader classLoader = null;
        if (null != obj) {
            classLoader = ClassExtensions.isDerivate(Thread.currentThread().getContextClassLoader(), obj.getClass().getClassLoader()) ? obj.getClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
            if (ClassExtensions.isDerivate(classLoader, ClassLoader.getSystemClassLoader())) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
        } else {
            classLoader = ClassExtensions.isDerivate(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()) ? ClassLoader.getSystemClassLoader() : Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static String getClassname(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String className = clazz.getName();
        return className;
    }

    public static String getClassnameWithSuffix(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String className = clazz.getName();
        className = className.substring(className.lastIndexOf(46) + 1) + ".class";
        return className;
    }

    public static String getClassnameWithSuffix(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked @NonNull but is null");
        }
        return ClassExtensions.getClassnameWithSuffix(obj.getClass());
    }

    public static ClassType getClassType(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        if (clazz.isArray()) {
            return ClassType.ARRAY;
        }
        if (ClassExtensions.isCollection(clazz)) {
            return ClassType.COLLECTION;
        }
        if (ClassExtensions.isMap(clazz)) {
            return ClassType.MAP;
        }
        if (clazz.isLocalClass()) {
            return ClassType.LOCAL;
        }
        if (clazz.isMemberClass()) {
            return ClassType.MEMBER;
        }
        if (clazz.isPrimitive()) {
            return ClassType.PRIMITIVE;
        }
        if (clazz.isAnnotation()) {
            return ClassType.ANNOTATION;
        }
        if (clazz.isEnum()) {
            return ClassType.ENUM;
        }
        if (clazz.isInterface()) {
            return ClassType.INTERFACE;
        }
        if (clazz.isSynthetic()) {
            return ClassType.SYNTHETIC;
        }
        if (clazz.isAnonymousClass()) {
            return ClassType.ANONYMOUS;
        }
        return ClassType.DEFAULT;
    }

    public static String getCurrentMethodName(@NonNull StackTraceElement[] elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked @NonNull but is null");
        }
        String currentMethodName = null;
        boolean isNext = false;
        for (StackTraceElement element : elements) {
            if (isNext) {
                currentMethodName = element.getMethodName();
                break;
            }
            isNext = element.getMethodName().equals("getStackTrace");
        }
        return currentMethodName;
    }

    public static List<File> getDirectoriesFromResources(@NonNull String path, boolean isPackage) throws IOException, URISyntaxException {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        if (isPackage) {
            path = path.replace('.', '/');
        }
        List<URL> resources = ClassExtensions.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        for (URL resource : resources) {
            dirs.add(new File(URLDecoder.decode(resource.getFile(), "UTF-8")));
        }
        return dirs;
    }

    public static String getJarPath(@NonNull Class<?> clazz) {
        String classUrlString;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String jarPath = null;
        String jarPathPrefix = "jar:";
        String jarPathFilePrefix = "jar:file:";
        String path = ClassExtensions.getPath(clazz);
        URL classUrl = ClassExtensions.getResource(path);
        if (classUrl != null && (classUrlString = classUrl.toString()).startsWith("jar:") && classUrlString.indexOf(path) > 0 && (jarPath = classUrlString.replace("!" + path, "")).startsWith("jar:file:")) {
            int beginIndex = "jar:file:".length();
            jarPath = jarPath.substring(beginIndex, jarPath.length());
        }
        return jarPath;
    }

    public static Class<?>[] getJdkProxyInterfaces(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        Class<?> found = clazz;
        if (ClassExtensions.isJdkProxy(found)) {
            return found.getInterfaces();
        }
        return new Class[]{found};
    }

    public static String getManifestUrl(@NonNull Class<?> clazz) {
        String classUrlString;
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String manifestUrl = null;
        String path = ClassExtensions.getPath(clazz);
        URL classUrl = ClassExtensions.getResource(path);
        if (classUrl != null && ((classUrlString = classUrl.toString()).startsWith("jar:") && classUrlString.indexOf(path) > 0 || classUrlString.startsWith("war:") && classUrlString.indexOf(path) > 0 || classUrlString.startsWith("ear:") && classUrlString.indexOf(path) > 0 || classUrlString.startsWith("file:") && classUrlString.indexOf(path) > 0)) {
            manifestUrl = classUrlString.replace(path, "/META-INF/MANIFEST.MF");
        }
        return manifestUrl;
    }

    public static String getName(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        return ClassExtensions.getName(clazz, false);
    }

    public static String getName(Class<?> clazz, boolean simple) {
        String name = null;
        if (clazz != null) {
            while (clazz.isAnonymousClass()) {
                clazz = clazz.getSuperclass();
            }
            name = simple ? clazz.getSimpleName() : clazz.getName();
        }
        return name;
    }

    public static String getPath(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String packagePath = PackageExtensions.getPackagePath(clazz);
        String className = ClassExtensions.getSimpleName(clazz);
        StringBuilder sb = new StringBuilder().append("/").append(packagePath).append(className).append(".class");
        String path = sb.toString();
        return path;
    }

    public static String getPathFromObject(Object obj) {
        if (obj == null) {
            return null;
        }
        String pathFromObject = obj.getClass().getResource(ClassExtensions.getClassnameWithSuffix(obj)).getPath();
        return pathFromObject;
    }

    public static URL getResource(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String path = ClassExtensions.getPath(clazz);
        URL url = clazz.getResource(path);
        if (url == null) {
            url = ClassExtensions.getClassLoader().getResource(path);
        }
        return url;
    }

    public static URL getResource(@NonNull Class<?> clazz, @NonNull String path) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        URL url = clazz.getResource(path);
        if (url == null) {
            url = ClassExtensions.getClassLoader().getResource(path);
        }
        return url;
    }

    public static URL getResource(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        String path = name;
        if (name.startsWith("/")) {
            path = name.substring(1, name.length());
        }
        URL url = ClassExtensions.getClassLoader().getResource(path);
        return url;
    }

    public static <T> URL getResource(@NonNull String name, @NonNull T obj) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked @NonNull but is null");
        }
        Class<?> clazz = obj.getClass();
        URL url = clazz.getResource(name);
        if (url == null) {
            url = ClassExtensions.getResource(clazz, name);
        }
        return url;
    }

    public static File getResourceAsFile(@NonNull String name) throws URISyntaxException {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        File file = null;
        URL url = ClassExtensions.getResource(name);
        if (null == url) {
            url = ClassExtensions.getClassLoader().getResource(name);
            if (null != url) {
                file = new File(url.toURI());
            }
        } else {
            if (url.getProtocol().equals("jar")) {
                throw new URISyntaxException(url.toString(), "Resource is in a jar file. Use instead the method ClassExtensions#getResourceAsStream(String). Given resource is");
            }
            if (url.getProtocol().equals("file")) {
                file = new File(url.toURI());
            }
        }
        return file;
    }

    public static File getResourceAsFile(@NonNull String name, @NonNull Object obj) throws URISyntaxException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked @NonNull but is null");
        }
        File file = null;
        URL url = ClassExtensions.getResource(name, obj);
        if (null == url) {
            url = ClassExtensions.getClassLoader(obj).getResource(name);
            if (null != url) {
                file = new File(url.toURI());
            }
        } else {
            if (url.getProtocol().equals("jar")) {
                InputStream resourceAsStream = ClassExtensions.getResourceAsStream(name, obj);
                file = new File(System.getProperty("java.io.tmpdir"), obj.getClass().getSimpleName());
                Files.copy(resourceAsStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (url.getProtocol().equals("file")) {
                file = new File(url.toURI());
            }
        }
        return file;
    }

    public static InputStream getResourceAsStream(@NonNull Class<?> clazz, @NonNull String uri) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked @NonNull but is null");
        }
        InputStream is = clazz.getResourceAsStream(uri);
        if (null == is) {
            is = ClassExtensions.getClassLoader().getResourceAsStream(uri);
        }
        return is;
    }

    public static InputStream getResourceAsStream(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        ClassLoader loader = ClassExtensions.getClassLoader();
        InputStream inputStream = loader.getResourceAsStream(name);
        return inputStream;
    }

    public static InputStream getResourceAsStream(@NonNull String name, @NonNull Object obj) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (obj == null) {
            throw new NullPointerException("obj is marked @NonNull but is null");
        }
        InputStream inputStream = obj.getClass().getResourceAsStream(name);
        if (null == inputStream) {
            ClassLoader loader = ClassExtensions.getClassLoader(obj);
            inputStream = loader.getResourceAsStream(name);
        }
        return inputStream;
    }

    public static List<URL> getResources(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        ClassLoader classLoader = ClassExtensions.getClassLoader();
        ArrayList<URL> list = Collections.list(classLoader.getResources(path));
        return list;
    }

    public static String getSimpleName(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        return ClassExtensions.getName(clazz, true);
    }

    public static Class<?> getUnwrappedProxy(Class<?> clazz) {
        Class<?>[] found = ClassExtensions.unwrapProxy(clazz);
        if (found != null && 0 < found.length) {
            return found[0];
        }
        return null;
    }

    public static URL getURL(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        return ClassExtensions.getResource(ClassExtensions.getPath(clazz));
    }

    public static <T> boolean isCglib(Class<T> clazz) {
        return clazz != null && clazz.getName().contains(CGLIB_TAG);
    }

    public static boolean isCollection(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isDerivate(ClassLoader source, ClassLoader compare) {
        if (source == compare) {
            return true;
        }
        if (compare == null) {
            return false;
        }
        if (source == null) {
            return true;
        }
        while (null != compare) {
            if (source != (compare = compare.getParent())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isJdkProxy(Class<T> clazz) {
        return clazz != null && Proxy.isProxyClass(clazz);
    }

    public static boolean isMap(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static <T> boolean isProxy(Class<T> clazz) {
        return ClassExtensions.isJdkProxy(clazz) || ClassExtensions.isCglib(clazz);
    }

    public static Class<?>[] unwrapProxy(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Class<?> found = clazz;
        if (ClassExtensions.isCglib(found)) {
            found = ClassExtensions.getCglibProxy(found);
        }
        if (ClassExtensions.isJdkProxy(found)) {
            return ClassExtensions.getJdkProxyInterfaces(found);
        }
        return new Class[]{found};
    }

    private ClassExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

