/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import lombok.NonNull;

public final class PackageExtensions {
    public static String getPackageName(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String packageName = clazz.getPackage().getName();
        return packageName;
    }

    public static String getPackageName(@NonNull String qualifiedClassName) {
        if (qualifiedClassName == null) {
            throw new NullPointerException("qualifiedClassName is marked @NonNull but is null");
        }
        String packageName = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("."));
        return packageName;
    }

    public static String getPackageNameWithDot(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String packageName = clazz.getPackage().getName() + ".";
        return packageName;
    }

    public static String getPackagePath(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String packagePath = PackageExtensions.getPackageName(clazz).replace('.', '/') + "/";
        return packagePath;
    }

    public static String getPackagePath(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        return PackageExtensions.getPackagePath(object.getClass());
    }

    public static String getPackagePath(@NonNull String packagePathWithDots) {
        if (packagePathWithDots == null) {
            throw new NullPointerException("packagePathWithDots is marked @NonNull but is null");
        }
        return PackageExtensions.getPackagePath(packagePathWithDots, false);
    }

    public static String getPackagePath(@NonNull String packagePathWithDots, boolean withEndSlash) {
        if (packagePathWithDots == null) {
            throw new NullPointerException("packagePathWithDots is marked @NonNull but is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(packagePathWithDots.replace('.', '/'));
        if (withEndSlash) {
            sb.append("/");
        }
        String packagePath = sb.toString();
        return packagePath;
    }

    public static String getPackagePathWithSlash(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        String packagePath = "/" + PackageExtensions.getPackagePath(clazz);
        return packagePath;
    }

    public static String getPackagePathWithSlash(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        return PackageExtensions.getPackagePathWithSlash(object.getClass());
    }

    private PackageExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

