/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections;

import de.alpharogroup.collections.VectorExtensions;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Comparator<Object> comparator;

    private Comparator<Object> getComparator() {
        if (this.comparator == null) {
            this.comparator = this.newComparator();
        }
        return this.comparator;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<Object> keys = VectorExtensions.toVector(super.keys());
        Collections.sort(keys, this.getComparator());
        return keys.elements();
    }

    @Override
    public Set<Object> keySet() {
        TreeSet<Object> set = new TreeSet<Object>(this.getComparator());
        set.addAll(super.keySet());
        return set;
    }

    protected Comparator<Object> newComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    @Override
    public Enumeration<?> propertyNames() {
        TreeSet<Object> set = new TreeSet<Object>(this.getComparator());
        set.addAll(super.keySet());
        return Collections.enumeration(set);
    }
}

