/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public class MapExtensions {
    public static <K, V> K getKeyFromValue(Map<K, V> map, V value) {
        Map.Entry<K, V> entry;
        K key = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && !map.get(key = (K)(entry = iterator.next()).getKey()).equals(value)) {
        }
        return key;
    }

    public static <K, V> Collection<K> getKeysFromValue(Map<K, V> map, V value) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V val = entry.getValue();
            if (!val.equals(value)) continue;
            K key = entry.getKey();
            keys.add(key);
        }
        return keys;
    }

    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapExtensions.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return LazyMap.lazyMap(new HashMap(), (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> void printMap(Map<K, V> msg) {
        for (Map.Entry<K, V> entry : msg.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            System.out.println("[" + key.toString() + "=" + value.toString() + "]");
        }
    }

    public static <T> Map<T, T> toGenericMap(T[][] twoDimArray) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T[] element : twoDimArray) {
            T key = element[0];
            T value = element[1];
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> toMap(String[][] twoDimArray) {
        return MapExtensions.toGenericMap(twoDimArray);
    }
}

