/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.pairs;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class Triple<L, M, R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private L left;
    private M middle;
    private R right;

    public static <L, M, R> TripleBuilder<L, M, R> builder() {
        return new TripleBuilder();
    }

    public TripleBuilder<L, M, R> toBuilder() {
        return new TripleBuilder().left(this.left).middle(this.middle).right(this.right);
    }

    public L getLeft() {
        return this.left;
    }

    public M getMiddle() {
        return this.middle;
    }

    public R getRight() {
        return this.right;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public void setMiddle(M middle) {
        this.middle = middle;
    }

    public void setRight(R right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        L this$left = this.getLeft();
        L other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        M this$middle = this.getMiddle();
        M other$middle = other.getMiddle();
        if (this$middle == null ? other$middle != null : !this$middle.equals(other$middle)) {
            return false;
        }
        R this$right = this.getRight();
        R other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Triple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        L $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        M $middle = this.getMiddle();
        result = result * 59 + ($middle == null ? 43 : $middle.hashCode());
        R $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "Triple(left=" + this.getLeft() + ", middle=" + this.getMiddle() + ", right=" + this.getRight() + ")";
    }

    public Triple() {
    }

    @ConstructorProperties(value={"left", "middle", "right"})
    public Triple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public static class TripleBuilder<L, M, R> {
        private L left;
        private M middle;
        private R right;

        TripleBuilder() {
        }

        public TripleBuilder<L, M, R> left(L left) {
            this.left = left;
            return this;
        }

        public TripleBuilder<L, M, R> middle(M middle) {
            this.middle = middle;
            return this;
        }

        public TripleBuilder<L, M, R> right(R right) {
            this.right = right;
            return this;
        }

        public Triple<L, M, R> build() {
            return new Triple<L, M, R>(this.left, this.middle, this.right);
        }

        public String toString() {
            return "Triple.TripleBuilder(left=" + this.left + ", middle=" + this.middle + ", right=" + this.right + ")";
        }
    }
}

