/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.comparators;

import de.alpharogroup.check.Check;
import de.alpharogroup.comparators.ComparatorExtensions;
import java.io.Serializable;
import java.util.Comparator;

public class NullCheckComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> decoratedComparator;
    private final boolean nullIsGreaterThan;

    public static <T> Comparator<T> of(Comparator<T> decoratedComparator) {
        return NullCheckComparator.builder().decoratedComparator(decoratedComparator).build();
    }

    public static <T> NullCheckComparator<T> of(Comparator<T> decoratedComparator, boolean nullIsGreaterThan) {
        return NullCheckComparator.builder().decoratedComparator(decoratedComparator).nullIsGreaterThan(nullIsGreaterThan).build();
    }

    public NullCheckComparator(Comparator<T> decoratedComparator) {
        this(decoratedComparator, false);
    }

    public NullCheckComparator(Comparator<T> decoratedComparator, boolean nullIsGreaterThan) {
        Check.get().notNull(decoratedComparator, "decoratedComparator");
        this.decoratedComparator = decoratedComparator;
        this.nullIsGreaterThan = nullIsGreaterThan;
    }

    @Override
    public int compare(T object, T compareWithObject) {
        Integer nullCheck = ComparatorExtensions.nullCheck(object, compareWithObject, this.nullIsGreaterThan);
        if (nullCheck != null) {
            return nullCheck;
        }
        return this.decoratedComparator.compare(object, compareWithObject);
    }

    public static <T> NullCheckComparatorBuilder<T> builder() {
        return new NullCheckComparatorBuilder();
    }

    public NullCheckComparatorBuilder<T> toBuilder() {
        return new NullCheckComparatorBuilder<T>().decoratedComparator(this.decoratedComparator).nullIsGreaterThan(this.nullIsGreaterThan);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NullCheckComparator)) {
            return false;
        }
        NullCheckComparator other = (NullCheckComparator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Comparator<T> this$decoratedComparator = this.decoratedComparator;
        Comparator<T> other$decoratedComparator = other.decoratedComparator;
        if (this$decoratedComparator == null ? other$decoratedComparator != null : !((Object)this$decoratedComparator).equals(other$decoratedComparator)) {
            return false;
        }
        return this.nullIsGreaterThan == other.nullIsGreaterThan;
    }

    protected boolean canEqual(Object other) {
        return other instanceof NullCheckComparator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Comparator<T> $decoratedComparator = this.decoratedComparator;
        result = result * 59 + ($decoratedComparator == null ? 43 : $decoratedComparator.hashCode());
        result = result * 59 + (this.nullIsGreaterThan ? 79 : 97);
        return result;
    }

    public static class NullCheckComparatorBuilder<T> {
        private Comparator<T> decoratedComparator;
        private boolean nullIsGreaterThan;

        NullCheckComparatorBuilder() {
        }

        public NullCheckComparatorBuilder<T> decoratedComparator(Comparator<T> decoratedComparator) {
            this.decoratedComparator = decoratedComparator;
            return this;
        }

        public NullCheckComparatorBuilder<T> nullIsGreaterThan(boolean nullIsGreaterThan) {
            this.nullIsGreaterThan = nullIsGreaterThan;
            return this;
        }

        public NullCheckComparator<T> build() {
            return new NullCheckComparator<T>(this.decoratedComparator, this.nullIsGreaterThan);
        }

        public String toString() {
            return "NullCheckComparator.NullCheckComparatorBuilder(decoratedComparator=" + this.decoratedComparator + ", nullIsGreaterThan=" + this.nullIsGreaterThan + ")";
        }
    }
}

