/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.array;

import java.lang.reflect.Array;
import lombok.NonNull;

public final class ArrayFactory {
    public static <T> T[] newArray(Class<T> cls, int length) {
        return (Object[])Array.newInstance(cls, length);
    }

    @SafeVarargs
    public static <T> T[] newArray(T ... elements) {
        return elements;
    }

    public static <T> T[] newEmptyArray(@NonNull T[] array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return ArrayFactory.newEmptyArray(array, array.length);
    }

    public static <T> T[] newEmptyArray(@NonNull T[] array, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return (Object[])Array.newInstance(array.getClass().getComponentType(), length);
    }

    public static Integer[] newRangeArray(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("Parameter end should be greater than parameter start.");
        }
        int length = end - start + 1;
        Integer[] array = new Integer[length];
        for (int i = start; i <= end; ++i) {
            array[i - start] = i;
        }
        return array;
    }

    @SafeVarargs
    public static boolean[] newBooleanArray(boolean ... elements) {
        return elements;
    }

    @SafeVarargs
    public static byte[] newByteArray(byte ... elements) {
        return elements;
    }

    @SafeVarargs
    public static char[] newCharArray(char ... elements) {
        return elements;
    }

    @SafeVarargs
    public static int[] newIntArray(int ... elements) {
        return elements;
    }

    @SafeVarargs
    public static long[] newLongArray(long ... elements) {
        return elements;
    }

    @SafeVarargs
    public static float[] newFloatArray(float ... elements) {
        return elements;
    }

    @SafeVarargs
    public static double[] newDoubleArray(double ... elements) {
        return elements;
    }

    @SafeVarargs
    public static short[] newShortArray(short ... elements) {
        return elements;
    }

    public static <T> T[] newSubArray(@NonNull T[] source, int startIndex, int endIndex) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        int newSize = endIndex - startIndex;
        T[] subArray = ArrayFactory.newEmptyArray(source, newSize);
        for (int i = 0; i < newSize; ++i) {
            subArray[i] = source[i + startIndex];
        }
        return subArray;
    }

    private ArrayFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

