/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.set;

import de.alpharogroup.collections.array.ArrayFactory;
import de.alpharogroup.collections.set.SetFactory;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import lombok.NonNull;

public final class SetExtensions {
    public static <T> T[] toArray(@NonNull Set<T> set) {
        if (set == null) {
            throw new NullPointerException("set is marked non-null but is null");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("set is empty");
        }
        ?[] newArray = ArrayFactory.newArray(set.iterator().next().getClass(), set.size());
        return set.toArray(newArray);
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        return SetFactory.newHashSet(collection, new Object[0]);
    }

    public static <T> SortedSet<T> toSortedSet(Collection<T> collection) {
        return SetFactory.newTreeSet(collection, new Object[0]);
    }

    private SetExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

