/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.list;

import de.alpharogroup.check.Argument;
import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.array.ArrayFactory;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.list.OptionalListExtensions;
import de.alpharogroup.collections.modifications.ModifiedCollections;
import de.alpharogroup.comparators.SortOrderComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections4.ComparatorUtils;

public final class ListExtensions {
    private static void computeAllCombinations(List<List<Integer>> allCombinations, List<Integer> possibleNumbers, Integer[] currentCombination, int currentStart, int currentEnd, int currentCombinationIndex, int combinationSize) {
        if (currentCombinationIndex == combinationSize) {
            allCombinations.add(ListFactory.newArrayList(currentCombination));
            return;
        }
        for (int i = currentStart; i <= currentEnd && currentEnd - i + 1 >= combinationSize - currentCombinationIndex; ++i) {
            currentCombination[currentCombinationIndex] = possibleNumbers.get(i);
            ListExtensions.computeAllCombinations(allCombinations, possibleNumbers, currentCombination, i + 1, currentEnd, currentCombinationIndex + 1, combinationSize);
        }
    }

    public static <T> boolean containAtleastOneObject(List<T> toSearch, List<T> search) {
        boolean contains = false;
        int size = toSearch.size();
        for (int i = 0; i < size && !(contains = search.contains(toSearch.get(i))); ++i) {
        }
        return contains;
    }

    public static List<List<Integer>> getAllCombinations(List<Integer> possibleNumbers, int combinationSize) {
        Argument.notNull(possibleNumbers, (String)"possibleNumbers");
        Integer[] currentCombination = new Integer[combinationSize];
        List<List<Integer>> allCombinations = ListFactory.newArrayList(new List[0]);
        int currentEnd = possibleNumbers.size() - 1;
        int currentStart = 0;
        int currentCombinationIndex = 0;
        ListExtensions.computeAllCombinations(allCombinations, possibleNumbers, currentCombination, currentStart, currentEnd, currentCombinationIndex, combinationSize);
        return allCombinations;
    }

    public static <T> List<List<T>> getCombinations(List<T> possibleValues, int combinationSize) {
        List<List<T>> combinations = ListFactory.newArrayList(new List[0]);
        if (combinationSize == 0) {
            combinations.add(ListFactory.newArrayList(new Object[0]));
            return combinations;
        }
        for (int i = 0; i < possibleValues.size(); ++i) {
            T element = possibleValues.get(i);
            List<T> rest = ListExtensions.getPartialList(possibleValues, i + 1);
            for (List<T> previous : ListExtensions.getCombinations(rest, combinationSize - 1)) {
                previous.add(element);
                combinations.add(previous);
            }
        }
        return combinations;
    }

    public static <T> T getFirst(List<T> list) {
        if (CollectionExtensions.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionExtensions.isNotEmpty(list)) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static <T> ModifiedCollections<T> getModifiedCollections(Collection<T> previous, Collection<T> next) {
        return new ModifiedCollections<T>().getModifiedLists(previous, next);
    }

    private static <T> List<T> getPartialList(List<T> list, int i) {
        List<Object> partialList = ListFactory.newArrayList(new Object[0]);
        for (int j = i; j < list.size(); ++j) {
            partialList.add(list.get(j));
        }
        return partialList;
    }

    public static <T> List<T> getSameElementsFromLists(List<T> toSearch, List<T> search) {
        toSearch.retainAll(search);
        return ListFactory.newArrayList(toSearch, new Object[0]);
    }

    public static <T> boolean hasNext(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        int indexOfElement = list.indexOf(element);
        if (indexOfElement == -1) {
            return false;
        }
        return indexOfElement < list.size() - 1;
    }

    public static <T> boolean hasPrevious(List<T> list, T element) {
        Argument.notNull(list, (String)"list");
        int indexOfElement = list.indexOf(element);
        return indexOfElement != -1 && indexOfElement != 0;
    }

    public static <T> boolean isEqualListOfArrays(List<T[]> one, List<T[]> other) {
        Optional<Boolean> optionalEvaluation = CollectionExtensions.preconditionOfEqualCollection(one, other);
        if (optionalEvaluation.isPresent()) {
            return optionalEvaluation.get();
        }
        for (int i = 0; i < one.size(); ++i) {
            if (Arrays.deepEquals(one.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isFirst(List<T> list, T element) {
        int indexOfElement = list.indexOf(element);
        return indexOfElement == 0;
    }

    public static <T> boolean isLast(List<T> list, T element) {
        Optional<T> optionalLast = OptionalListExtensions.getLast(list);
        if (optionalLast.isPresent()) {
            return optionalLast.get().equals(element);
        }
        return false;
    }

    public static <T> List<T> rearrange(T element, List<T> listToResort, int rearrangeToIndex) {
        Argument.notNull(element, (String)"element");
        Argument.notNull(listToResort, (String)"listToResort");
        int index = listToResort.indexOf(element);
        if (index < 0 || index == rearrangeToIndex || listToResort.size() == rearrangeToIndex) {
            return listToResort;
        }
        List<Object> resortedList = ListFactory.newArrayList(listToResort, new Object[0]);
        resortedList.remove(index);
        resortedList.add(rearrangeToIndex, element);
        return resortedList;
    }

    public static <T> T removeFirst(List<T> list) {
        if (!CollectionExtensions.isEmpty(list) && 0 < list.size()) {
            return list.remove(0);
        }
        return null;
    }

    public static <T> T removeLast(List<T> list) {
        if (!CollectionExtensions.isEmpty(list) && 0 < list.size()) {
            return list.remove(list.size() - 1);
        }
        return null;
    }

    public static <T> List<T> removeLastValues(List<T> v, int remove) {
        if (remove < v.size()) {
            return v.subList(remove, v.size());
        }
        throw new IllegalArgumentException("You cannot remove more element than in the ArrayList exists. \nSize from ArrayList:" + v.size() + "\nElements to be removed:" + remove + "\n The same ArrayList will be returned.");
    }

    public static <T> List<T> revertOrder(List<T> listToRevert) {
        List<Object> revertedList = ListFactory.newArrayList(new Object[0]);
        int size = listToRevert.size();
        while (0 < size) {
            revertedList.add(listToRevert.get(--size));
        }
        return revertedList;
    }

    public static <T> void shuffle(List<T> source, List<T> destination, int[] selectedElements) {
        int lastIndex;
        for (int i = lastIndex = selectedElements.length - 1; -1 < i; --i) {
            int selectedRow = selectedElements[i];
            T row = source.remove(selectedRow);
            destination.add(row);
        }
    }

    public static <T> void sortByProperty(List<T> list, String property, boolean ascending) {
        Object comparator = new BeanComparator(property, SortOrderComparator.of());
        if (ascending) {
            comparator = ComparatorUtils.reversedComparator((Comparator)comparator);
        }
        list.sort((Comparator<T>)comparator);
    }

    public static <T> List<List<T>> splitToParts(Collection<T> collection, int size) {
        List<List<T>> returnList = ListFactory.newArrayList(new List[0]);
        List<Object> tmp = ListFactory.newArrayList(new Object[0]);
        Iterator<T> it = collection.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count == size) {
                returnList.add(tmp);
                tmp = ListFactory.newArrayList(new Object[0]);
                tmp.add(it.next());
                count = 1;
                continue;
            }
            tmp.add(it.next());
            ++count;
        }
        if (!tmp.isEmpty()) {
            returnList.add(tmp);
        }
        return returnList;
    }

    public static <T> T[] toArray(List<T> list) {
        Argument.notNull(list, (String)"list");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("list is empty");
        }
        ?[] newArray = ArrayFactory.newArray(list.get(0).getClass(), list.size());
        return list.toArray(newArray);
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... elements) {
        return ArrayFactory.newArray(elements);
    }

    public static <T> List<T> toList(Enumeration<T> enumaration) {
        List<Object> list = ListFactory.newArrayList(new Object[0]);
        while (enumaration.hasMoreElements()) {
            list.add(enumaration.nextElement());
        }
        return list;
    }

    public static <T> List<T> toList(Set<T> set) {
        return ListFactory.newArrayList(set, new Object[0]);
    }

    @SafeVarargs
    public static <T> Object[] toObjectArray(T ... elements) {
        Object[] decorator = new Object[elements.length];
        System.arraycopy(elements, 0, decorator, 0, elements.length);
        return decorator;
    }

    private ListExtensions() {
    }
}

