/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.collections.map;

import de.alpharogroup.check.Argument;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.InsertionOrderMap;
import de.alpharogroup.collections.pairs.KeyValuePair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.map.LazyMap;

public final class MapFactory {
    public static Map<Integer, Map<String, String>> newAssosiativeArrayMap() {
        return MapFactory.newLazyMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K> Map<K, Integer> newCounterMap(Collection<K> elements) {
        Objects.requireNonNull(elements);
        return MapFactory.newCounterMap(MapFactory.newHashMap(), elements);
    }

    public static <K> Map<K, Integer> newCounterMap(Map<K, Integer> counterMap, Collection<K> elements) {
        Objects.requireNonNull(counterMap);
        for (K element : elements) {
            if (counterMap.containsKey(element)) {
                counterMap.merge(element, 1, Integer::sum);
                continue;
            }
            counterMap.put(element, 0);
        }
        return counterMap;
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newHashMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newHashMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newHashMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newInsertionOrderMap() {
        return new InsertionOrderMap();
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newInsertionOrderMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(int initialCapacity) {
        return new InsertionOrderMap(initialCapacity);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newInsertionOrderMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newInsertionOrderMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newInsertionOrderMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new InsertionOrderMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newLazyHashMap() {
        return MapFactory.newLazyHashMap(new HashMap());
    }

    public static <K, V> Map<K, V> newLazyHashMap(HashMap<K, V> map) {
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(HashMap.class));
    }

    public static <K, V> Map<K, V> newLazyMap() {
        return MapFactory.newLazyHashMap();
    }

    public static <K, V> Map<K, V> newLazyTreeMap() {
        return MapFactory.newLazyTreeMap(new TreeMap());
    }

    public static <K, V> Map<K, V> newLazyTreeMap(Comparator<? super K> comparator) {
        Argument.notNull(comparator, (String)"comparator");
        return LazyMap.lazyMap(new TreeMap(comparator), (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLazyTreeMap(TreeMap<K, V> map) {
        Argument.notNull(map, (String)"map");
        return LazyMap.lazyMap(map, (Factory)new InstantiateFactory(TreeMap.class));
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newLinkedHashMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newLinkedHashMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newLinkedHashMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newLinkedHashMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> newTreeMap(Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newTreeMap(KeyValuePair.toMap(keyValuePairs));
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator) {
        Argument.notNull(comparator, (String)"comparator");
        return new TreeMap(comparator);
    }

    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator, Collection<KeyValuePair<K, V>> keyValuePairs) {
        Argument.notNull(comparator, (String)"comparator");
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(MapFactory.newTreeMap(keyValuePairs));
        return treeMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newTreeMap(Comparator<? super K> comparator, KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(comparator, (String)"comparator");
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(MapFactory.newTreeMap(keyValuePairs));
        return treeMap;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newTreeMap(KeyValuePair<K, V> ... keyValuePairs) {
        Argument.notNull(keyValuePairs, (String)"keyValuePairs");
        return MapFactory.newTreeMap(ListFactory.newArrayList(keyValuePairs));
    }

    public static <K, V> Map<K, V> newTreeMap(Map<K, V> map) {
        Argument.notNull(map, (String)"map");
        return new TreeMap<K, V>(map);
    }

    private MapFactory() {
    }
}

